<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('viaggiando_slick_slider_function')) {

	function viaggiando_slick_slider_function($catID = false) {
		
		$args = array(
			'post_type' => 'post',
			'posts_per_page' => 3,
			'orderby' => 'date',
			'order' => 'DESC',
			
		);

		if ( is_archive() ) :

			$taxonomyType = get_queried_object();

			if ( 
				is_category() ||
				is_tag() ||
				is_tax('post_format')
			) {
								
				$args['tax_query'] = array(
									
					array(
						'taxonomy' => $taxonomyType->taxonomy,
						'field' => 'term_id',
						'terms' => $taxonomyType->term_id,
						'operator' => 'IN'
					),
											 
				);
	
			} elseif (is_author()) {

				$args['author__in'] = $taxonomyType->ID;
	
			}

		endif;
		
		$query = new WP_Query($args); 
		
		if ( $query->have_posts() ) :  
                                
?>

        <div class="post-container slick-slideshow" data-columns="1" center-mode="false" adaptive-height="true">

            <div class="slider slick-slides">

			<?php
        
                if ( $query->have_posts() ) : while ( $query->have_posts() ) : $query->the_post(); 
        
                    global $post;
					
					$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'viaggiando_slideshow');
                    $thumbnailIMG = (!empty($thumb)) ? $thumb[0] : get_stylesheet_directory_uri()."/assets/images/placeholder-630x420.jpg";
					$thumbnailALT = (get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true )) ? get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) : get_the_title() ;

			?>
			
					<div>
				   
						<div class="slick-article">

							<img src="<?php echo esc_url($thumbnailIMG); ?>" alt="<?php echo esc_attr($thumbnailALT); ?>">
							
							<div class="slider-overlay">
							    
							    <div class="slider-overlay-wrapper">
							    
							    	<div class="slider-overlay-content">

							            <span class="entry-category"><?php the_category(' . '); ?></span>

							            <h2 class="title">
                                        
							            	<a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
							            
                                        		<?php echo get_the_title(); ?>
							            
                                        	</a>
							            
                                        </h2>
							            
							    	</div>
							    
							    </div>
							    
							</div>
                            
						</div>
						
					</div>
			
			<?php

				endwhile; 
				endif;
				wp_reset_postdata();

			?>

            </div>
            
        </div>

<?php

        endif;
	
	}

	add_action( 'viaggiando_slick_slider', 'viaggiando_slick_slider_function', 10);

}

?>