<?php
/**
 * The template for displaying all single posts and attachments
 *
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
get_header();
?>
<div class="container">
    <div class="body-content">
        <div class="breadcum inbreadcum triggerAnimation" data-animate="fadeInDown">
            <div class="container">        	
                <a href="<?php echo esc_url(home_url('/')); ?> "><?php echo __('Home', 'vg-responsive-simple'); ?></a> >> <span class="current"><?php the_title(); ?></span>        </div>
        </div>
        <div class="body-left inbody-left one triggerAnimation" data-animate="fadeInLeft">
            <?php
            // Start the loop.
            while (have_posts()) : the_post();

                /*
                 * Include the post format-specific template for the content. If you want to
                 * use this in a child simple, then include a file called called content-___.php
                 * (where ___ is the post format) and that will be used instead.
                 */
                get_template_part('content', get_post_format());

                // If comments are open or we have at least one comment, load up the comment template.
                if (comments_open() || get_comments_number()) :
                    comments_template();
                endif;

                // Previous/next post navigation.
                the_post_navigation(array(
                    'next_text' => '<span class="meta-nav" aria-hidden="true">' . __('Next', 'vg-responsive-simple') . '</span> ' .
                    '<span class="screen-reader-text">' . __('Next post:', 'vg-responsive-simple') . '</span> ' .
                    '<span class="post-title">%title</span>',
                    'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __('Previous', 'vg-responsive-simple') . '</span> ' .
                    '<span class="screen-reader-text">' . __('Previous post:', 'vg-responsive-simple') . '</span> ' .
                    '<span class="post-title">%title</span>',
                ));

            // End the loop.
            endwhile;
            ?>
        </div>
        <div class="inbody-right">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>

