<?php
/**
 * The template for displaying search results pages.
 *
 *
 * @file           searchform.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php echo _x( 'Search for:', 'label', 'vg-responsive-simple' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'vg-responsive-simple' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	</label>
	<button type="submit" class="search-submit"><span class="screen-reader-text1"><?php echo _x( 'Search', 'submit button', 'vg-responsive-simple' ); ?></span></button>
</form>
