<?php
/**
 * The template for displaying search results pages.
 *
 *
 * @file           Search.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
get_header();
?>

<div class="container">
    <div class="body-content">

        <div class="breadcum inbreadcum triggerAnimation" data-animate="fadeInDown">
            <div class="container">        	
                <a href="<?php echo esc_url(home_url('/')); ?>"><?php echo __('Home', 'vg-responsive-simple'); ?></a> >> <span class="current"><?php the_title(); ?></span>        </div>
        </div>

        <div class="body-left inbody-left one triggerAnimation" data-animate="fadeInLeft">

            <?php if (have_posts()) : ?>
                <h1 class="page-title"><?php printf(__('Search Results for: %s', 'vg-responsive-simple'), get_search_query()); ?></h1>

                <?php
                // Start the loop.
                while (have_posts()) : the_post();
                    ?>

                    <?php
                    /*
                     * Run the loop for the search to output the results.
                     * If you want to overload this in a child simple then include a file
                     * called content-search.php and that will be used instead.
                     */
                    get_template_part('content', 'search');

                // End the loop.
                endwhile;

                // Previous/next page navigation.
                the_posts_pagination(array(
                    'prev_text' => __('Previous page', 'vg-responsive-simple'),
                    'next_text' => __('Next page', 'vg-responsive-simple'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>',
                ));

            // If no content, include the "No posts found" template.
            else :
                get_template_part('content', 'none');

            endif;
            ?>
        </div>
        <div class="inbody-right">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>