<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
get_header();
?>
<div class="container">
    <div class="body-content">

        <div class="breadcum inbreadcum triggerAnimation" data-animate="fadeInDown">
            <div class="container">        	
                <a href="<?php echo esc_url(home_url('/')); ?>"><?php echo __('Home', 'vg-responsive-simple'); ?></a> >> <span class="current"><?php the_title(); ?></span>        </div>
        </div>

        <div class="body-left inbody-left one triggerAnimation" data-animate="fadeInLeft">
            <?php
            // Start the loop.
            while (have_posts()) : the_post();

                // Include the page content template.
                get_template_part('content', 'page');

                // If comments are open or we have at least one comment, load up the comment template.
                if (comments_open() || get_comments_number()) :
                    comments_template();
                endif;

            // End the loop.
            endwhile;
            ?>
        </div>
        <div class="inbody-right">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
