<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress simple
 * and one of the two required files for a simple (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * e.g., it puts together the Home page when no Home.php file exists.
 *
 *
 * @file           index.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
get_header();
?>
<div class="Home_manin">
    <div class="container">
        <div class="about_content">
            <?php if (have_posts()) : ?>
                <?php
                // Start the loop.
                while (have_posts()) : the_post();

                    /*
                     * Include the Post-Format-specific template for the content.
                     * If you want to override this in a child simple, then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */
                    get_template_part('content', get_post_format());

                // End the loop.
                endwhile;

                // Previous/next page navigation.
                the_posts_pagination(array(
                    'prev_text' => __('Previous page', 'vg-responsive-simple'),
                    'next_text' => __('Next page', 'vg-responsive-simple'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>',
                ));

            // If no content, include the "No posts found" template.
            else :
                get_template_part('content', 'none');

            endif;
            ?>
        </div>
    </div>
</div>
<?php get_footer(); ?>