<?php 
/* Custom code setup
 * Here we added crop image settings
 *
 *
 */
function vg_responsive_theme_prefix_setup() {
	
	add_theme_support( 'custom-logo', array(
		
		'height'      => 80,
		'width'       => 167,
		'flex-width' => true,
		'header-text' => array( 'site-title', 'site-description' ),
	) );

}
add_action( 'after_setup_theme', 'vg_responsive_theme_prefix_setup' );

function vg_responsive_theme_the_custom_logo() {
	
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}

}


/*
 * Custom Background setup
 *
 */
 
 
 add_theme_support( 'custom-header', array(
    'default-color' => '#FFFFFF',
		
      
) ); 


$args = array(
	'width'         => 1140,
	'height'        => 250,
	'default-image' => '',
	'wp-head-callback' => 'vg_responsive_theme_header_css',
);
add_theme_support( 'custom-header', $args );

/*
 * Adding header image
 */
 
 function vg_responsive_theme_header_css() {
	$header_image = get_header_image();

	// If no custom options for text are set, let's bail.
	if ( empty( $header_image ) && display_header_text() ) {
		return;
	}
	
	
 if ( ! empty( $header_image ) ) :
 ?>
<style type="text/css" id="vg_responsive_theme_header_css">
	
.ha-header-front {
			background-image: url(<?php header_image(); ?>);
			background-repeat: no-repeat;
			background-position: 50% 50%;
			-webkit-background-size: cover;
			-moz-background-size:    cover;
			-o-background-size:      cover;
			background-size:         cover;
}
	
	
</style>

 <?php 	 endif;
	 } ?>
 
 