<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @version        Release: 1.0
 */
?>
<!DOCTYPE html>
<html 
    <?php language_attributes(); ?> class="no-js">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">

        <?php wp_head(); ?>

    </head>
    <body
        <?php body_class(); ?> >
				<div id="wrapper">
        <div  id="ha-header" class="ha-header ha-header-large header  cbp-af-header">
            <div class="ha-header-perspective">
                <header class="ha-header-front">
                    <div class="container">
                        <div class="logo">

                            <?php the_custom_logo();
															
															if (!has_custom_logo()) {?>

                                <div class="blog_name">
                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="Home"><?php bloginfo('name'); ?></a>
                                </div>
															<?php } ?>
                            
                        </div>
                        <i class="fa fa-navicon">
                            <a href="#" class="toggle">
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/menu_logo.JPG">
                            </a>
                        </i>
                        <div class="menu_bt">
                            <div class="nav_menu">
                                <?php wp_nav_menu(array('theme_location' => 'primary', 'menu_class' => 'nav-menu', 'menu_id' => 'trans-nav')); ?>
                            </div>
                        </div>
                    </div>
                </header>
                <div class="menu">
                    <?php
                    if (has_nav_menu('Mobile')) {
                        wp_nav_menu(array(
                            'theme_location' => 'Mobile', 'menu_class' => 'nav-menu1', 'menu_id' => 'trans-nav1'));
                    } else {
                        ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>wp-admin/nav-menus.php">Click here to add Mobile Menu</a> 
                    <?php } ?>

                </div>
            </div>
        </div>  