<?php

/**
 * functions Template
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
if (!isset($content_width)) {
    $content_width = 660;
}

if (!function_exists('vg_responsive_theme_setup')) :

    function vg_responsive_theme_setup() {


        load_theme_textdomain('vg-responsive-simple');

        add_theme_support('automatic-feed-links');

        add_theme_support('title-tag');
				
				add_theme_support( 'custom-logo' );
				
				add_theme_support( 'custom-background' );
				
				add_theme_support( 'custom-header' );
				
				add_editor_style('css/editor-style.css');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        register_nav_menus(array(
            'primary' => __('Primary Menu', 'vg-responsive-simple'),
            'footer' => __('Footer Menu', 'vg-responsive-simple'),
        ));
        add_theme_support('html5', array(
            'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
        ));
        add_theme_support('post-formats', array(
            'aside', 'image', 'audio', 'video', 'quote', 'link', 'chat'
        ));
    }

endif; // vg_responsive_theme_setup
add_action('after_setup_theme', 'vg_responsive_theme_setup');

/**
 * Register widget area.
 *
 */
function vg_responsive_theme_widgets_init() {
    register_sidebar(array(
        'name' => __('Widget Area', 'vg-responsive-simple'),
        'id' => 'sidebar-1',
        'description' => __('Add widgets here to appear in your sidebar.', 'vg-responsive-simple'),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget' => '</aside>',
        'before_title' => '<h4 class="widget-title">',
        'after_title' => '</h4>',
    ));
}

add_action('widgets_init', 'vg_responsive_theme_widgets_init');

/**
 * Enqueue scripts and styles.
 *
 */
function vg_responsive_theme_scripts() {

    // Load our main stylesheet.
    wp_enqueue_style('vg-responsive-simple-style', get_stylesheet_uri());

    // Load Bootstrap files
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/css/bootstrap.css');

    wp_enqueue_script('jquery-ajax', 'https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js');
    //Custom Js file

    wp_enqueue_script('custom', get_template_directory_uri() . '/js/custom.js');


    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}

add_action('wp_enqueue_scripts', 'vg_responsive_theme_scripts');

/* Mobile Menu Setup */
add_action('after_setup_theme', 'register_mobile_menu');

function register_mobile_menu() {
    register_nav_menu('Mobile', __('Mobile Menu', 'vg-responsive-simple'));
}

require get_template_directory() . '/inc/customizer.php';


?>