<?php
/**
 * The default template for displaying content
 *
 * Used for both single and index/archive/search.
 *
 *
 * @file           content.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <?php
    if (is_single()) :
        // Post thumbnail.
        $feat_image = wp_get_attachment_url(get_post_thumbnail_id($post->ID));
        ?>

        <?php if ($feat_image) { ?>
            <img src="<?php echo $feat_image; ?>"  />
        <?php
        }
    endif;
    ?>
    <header class="entry-header">
        <?php
        if (is_single()) :
            the_title('<h1 class="entry-title">', '</h1>');
            ?>
            <div class="posted_by"> <i class="glyphicon glyphicon-calendar"></i><span> <?php the_time('l, F jS, Y'); ?> </span>| <i class="glyphicon glyphicon-user"></i><span>  <?php the_author(); ?></span> | <i class="glyphicon glyphicon-align-center"></i> <?php the_category(','); ?></div>


            <?php
        else :
            the_title(sprintf('<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h2>');
        endif;
        ?>
    </header><!-- .entry-header -->

    <div class="entry-content">
        <?php
        /* translators: %s: Name of current post */
        the_content(sprintf(
                        __('Continue reading %s', 'vg-responsive-simple'), the_title('<span class="screen-reader-text">', '</span>', false)
        ));

        wp_link_pages(array(
            'before' => '<div class="page-links"><span class="page-links-title">' . __('Pages:', 'vg-responsive-simple') . '</span>',
            'after' => '</div>',
            'link_before' => '<span>',
            'link_after' => '</span>',
            'pagelink' => '<span class="screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>%',
            'separator' => '<span class="screen-reader-text">, </span>',
        ));
        ?>
    </div><!-- .entry-content -->

    <?php
// Author bio.
    if (is_single() && get_the_author_meta('description')) :
        get_template_part('author-bio');
    endif;
    ?>
 <?php if (!is_single()){?>
    <footer class="entry-footer">
            <?php //vg_responsive_theme_entry_meta();   ?>
        <small>  <i class="glyphicon glyphicon-calendar"></i>
<?php the_time('l, F jS, Y'); ?> || <i class="glyphicon glyphicon-user"></i> <?php the_author_posts_link(); ?>. || <i class="glyphicon glyphicon-align-center"></i> <?php the_category(','); ?> | <?php the_tags();?></small>

    </footer><!-- .entry-footer -->
 <?php } ?>

</article><!-- #post-## -->
