<?php
/**
 * The template used for displaying page content
 *
 *
 * @file           content-page.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <?php $feat_image = wp_get_attachment_url(get_post_thumbnail_id($post->ID)); ?>

    <?php if ($feat_image) { ?>
        <img src="<?php echo $feat_image; ?>"  />
    <?php } ?>
    <header class="entry-header">
        <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
    </header><!-- .entry-header -->

    <div class="entry-content">
        <?php the_content(); ?>
        <?php
        wp_link_pages(array(
            'before' => '<div class="page-links"><span class="page-links-title">' . __('Pages:', 'vg-responsive-simple') . '</span>',
            'after' => '</div>',
            'link_before' => '<span>',
            'link_after' => '</span>',
            'pagelink' => '<span class="screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>%',
            'separator' => '<span class="screen-reader-text">, </span>',
        ));
        ?>
    </div><!-- .entry-content -->

    <?php edit_post_link(__('Edit', 'vg-responsive-simple'), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->'); ?>

</article><!-- #post-## -->
