<?php
/**
 * The template for displaying link post formats
 *
 * Used for both single and index/archive/search.
 *
 * @file           content-link.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <?php the_post_thumbnail(); ?>

    <header class="entry-header">
        <?php
        if (is_single()) :
            the_title(sprintf('<h1 class="entry-title"><a href="%s">', esc_url(get_permalink($post->ID))), '</a></h1>');
        else :
            the_title(sprintf('<h2 class="entry-title"><a href="%s">', esc_url(get_permalink($post->ID))), '</a></h2>');
        endif;
        ?>
    </header>
    <!-- .entry-header -->

    <div class="entry-content">
        <?php
        /* translators: %s: Name of current post */
        the_content(sprintf(
                        __('Continue reading %s', 'vg-responsive-simple'), the_title('<span class="screen-reader-text">', '</span>', false)
        ));

        wp_link_pages(array(
            'before' => '<div class="page-links"><span class="page-links-title">' . __('Pages:', 'vg-responsive-simple') . '</span>',
            'after' => '</div>',
            'link_before' => '<span>',
            'link_after' => '</span>',
            'pagelink' => '<span class="screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>%',
            'separator' => '<span class="screen-reader-text">, </span>',
        ));
        ?>
    </div>
    <!-- .entry-content -->

    <?php
    // Author bio.
    if (is_single() && get_the_author_meta('description')) :
        get_template_part('author-bio');
    endif;
    ?>

    <footer class="entry-footer">
        <?php //the_entry_meta();  ?>
        <?php edit_post_link(__('Edit', 'vg-responsive-simple'), '<span class="edit-link">', '</span>'); ?>
    </footer>
    <!-- .entry-footer -->

</article><!-- #post-## -->
