<?php
/**
 * The template for displaying archive pages
 * Archive Template
 *
 *
 * @file           archive.php
 * @package        VG Responsive Simple 
 * @author         Venugopal
 * @license        license.txt
 * @version        Release: 1.0
 */
get_header();
?>
<div class="container">
    <div class="body-content">
        <div class="breadcum inbreadcum triggerAnimation" data-animate="fadeInDown">
            <div class="container">        	
                <a href="<?php echo esc_url(home_url('/')); ?>"><?php echo __('Home', 'vg-responsive-simple'); ?></a> >> <span class="current"><?php the_title(); ?></span>        </div>
        </div>
        <div class="body-left inbody-left one triggerAnimation" data-animate="fadeInLeft">
            <?php if (have_posts()) : ?>
                <?php
                the_archive_title('<h1 class="page-title">', '</h1>');
                the_archive_description('<div class="taxonomy-description">', '</div>');
                ?> 	<?php
                // Start the Loop.
                while (have_posts()) : the_post();
                    /*
                     * Include the Post-Format-specific template for the content.
                     * If you want to override this in a child simple, then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */
                    get_template_part('content', get_post_format());

                // End the loop.
                endwhile;

                // Previous/next page navigation.
                the_posts_pagination(array(
                    'prev_text' => __('Previous page', 'vg-responsive-simple'),
                    'next_text' => __('Next page', 'vg-responsive-simple'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('Page', 'vg-responsive-simple') . ' </span>',
                ));

            // If no content, include the "No posts found" template.
            else :
                get_template_part('content', 'none');

            endif;
            ?>
        </div>
        <div class="inbody-right">
            <?php get_sidebar(); ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>