<?php if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>	
<?php endif;  ?>
<!-- Header Area -->

	<?php 

		// header
		$tophead_text = esc_attr(get_theme_mod('tophead_text','Welcome to Pet Clinic Center!'));
		$tophead_mail = esc_attr(get_theme_mod('tophead_mail','demo@example.com'));
		$topheadefblink = esc_attr(get_theme_mod('tophead_fblink','#'));
		$topheadeinstalink = esc_attr(get_theme_mod('tophead_instalink','#'));
		$topheadetwitterlink = esc_attr(get_theme_mod('tophead_twitterlink','#'));
		$topheadewhtsapplink = esc_attr(get_theme_mod('tophead_whtsapplink','#'));

		$topheader_btntext = esc_attr(get_theme_mod('topheader_btntext','Appointment'));
		$topheader_btntextlink = esc_attr(get_theme_mod('topheader_btntextlink','#'));
		$stickyheader = esc_attr(veterinaryclinic_sticky_menu());
	?>

<div class="main">
    <header class="main-header site-header <?php echo esc_attr(veterinaryclinic_sticky_menu()); ?>">
		
			<div class="header-section">
				<div class="tophead ">
					<div class="container">					
						<div class=" row mr-0">
							<div class="col-lg-4 col-md-5 col-sm-5">
								<p><?php echo apply_filters('veterinaryclinic_header', $tophead_text); ?></p>
							</div>
							<div class="col-lg-4 col-md-5 col-sm-5 pd-0">
								<a class="h_mail" href="mailto:<?php echo apply_filters('veterinaryclinic_header', $tophead_mail); ?>">
									<i class="fa fa-envelope-o" aria-hidden="true"></i>
									<?php echo apply_filters('veterinaryclinic_header', $tophead_mail); ?>
								</a>
							</div>
							<div class="col-lg-4 col-md-2 col-sm-2 pd-0">
								<div class="socialicon">
									<a href="<?php echo apply_filters('veterinaryclinic_header', $tophead_fblink); ?>">
										<i class="fa fa-facebook" aria-hidden="true"></i>
									</a>
									<a href="<?php echo apply_filters('veterinaryclinic_header', $tophead_instalink); ?>">
										<i class="fa fa-instagram" aria-hidden="true"></i>
									</a>
									<a href="<?php echo apply_filters('veterinaryclinic_header', $tophead_twitterlink); ?>">
										<i class="fa fa-twitter" aria-hidden="true"></i>
									</a>
									<a href="<?php echo apply_filters('veterinaryclinic_header', $tophead_whtsapplink); ?>">
										<i class="fa fa-whatsapp" aria-hidden="true"></i>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			<div class="container">
				<div class="bottomhead ">
					<div class=" row mr-0">
						<div class="col-lg-3 col-md-3 col-sm-4 col-12 pd-0">
							<div class="logobx">
								<div class="site-logo">
									<?php
									if(has_custom_logo())
										{	
											the_custom_logo();
										}
										else { 
										?>
										<a class="site-title" href="<?php echo esc_url( home_url( '/' ) ); ?>">
											
											<?php 
												echo esc_html(bloginfo('name'));
											?>
										</a>	

										<div class="box-info">
											<?php
												$veterinaryclinic_site_desc = get_bloginfo( 'description');
												if ($veterinaryclinic_site_desc) : ?>
													<p class="site-description"><?php echo esc_html($veterinaryclinic_site_desc); ?></p>
											<?php endif; ?>
										</div>
									<?php 						
										}
									?>
								</div>
							</div>
						</div>
						<div class="col-lg-9 col-md-9 col-sm-8 col-12 pd-0">
							<div class="bottomhead ">
								<div class=" row mr-0">
									<div class="col-lg-9 col-md-7 col-sm-6 col-12">
										<div class="menus">
											<nav class="navbar navbar-expand-lg navbaroffcanvase">
											<div class="navbar-menubar">
												<!-- Small Divice Menu-->
												<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','veterinary-clinic'); ?>"> 
													<i class="fa fa-bars"></i>
												</button>
												<div class="collapse navbar-collapse navbar-menu">
													<button class="navbar-toggler navbar-toggler-close" type="button" data-bs-toggle="collapse" data-bs-target=".navbar-menu"  aria-label="<?php echo esc_attr_e('Toggle navigation','veterinary-clinic'); ?>"> 
														<i class="fa fa-times"></i>
													</button> 
													<?php 
														wp_nav_menu( 
															array(  
																'theme_location' => 'primary_menu',
																'container'  => '',
																'container_id'    => '',
																'menu_class' => 'navbar-nav main-nav',
																'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
																'walker' => new WP_Bootstrap_Navwalker()
																) 
															);
													?>
												</div>
											</div>
											</nav>
										</div>
									</div>
									<div class="col-lg-3 col-md-5 col-sm-6 col-12 pd-0">
										<div class="hbtn">
											<a class="contactus" href="<?php echo apply_filters('veterinaryclinic_header', $topheader_btntextlink); ?>">
												<?php echo apply_filters('veterinaryclinic_header', $topheader_btntext); ?>
											</a> 
										</div>
									</div>
								</div>
								<div class="clearfix"></div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

    </header>
	<div class="clearfix"></div>
</div>

