<?php
/**
 * The template for displaying search form.
 *
 * @package     Veterinary Clinic
 * @since       0.1
 */
?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	<label>
		<span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'veterinary-clinic' ); ?></span>
		<input type="search" class="search-field" placeholder="<?php esc_attr_e( 'Search …', 'veterinary-clinic' ); ?>" value="" name="s">
	</label>
	<button type="submit" class="search-submit" value="<?php esc_attr_e( 'Search', 'veterinary-clinic' ); ?>">
		<i class="fa fa-search"></i>
	</button>
</form>