<?php
function veterinaryclinic_blog_setting( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'veterinaryclinic_frontpage_sections', array(
			'priority' => 32,
			'title' => esc_html__( 'Frontpage Sections', 'veterinary-clinic' ),
		)
	);
	

	/*=========================================
	Slider Section
	=========================================*/
	$wp_customize->add_section(
		'slider_setting', array(
			'title' => esc_html__( 'Slider Section', 'veterinary-clinic' ),
			'description'=> __('<a>Note :</a> Image Size Should Be 1500*800','veterinary-clinic'),
			'priority' => 1,
			'panel' => 'veterinaryclinic_frontpage_sections',
		)
	);


	$wp_customize->add_setting('veterinaryclinic_slider_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new veterinaryclinic_Tab_Control($wp_customize, 'veterinaryclinic_slider_tabs', array(
	   'section' => 'slider_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'veterinary-clinic'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'slider1',
            	'slider2',
            	'slider3',
            	'slider4',
            	'slider5',
            	'slider6'
            ),
            'active' => true,
         ), 
	      array(
            'name' => esc_html__('Style', 'veterinary-clinic'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'slider_titlecolor',
                'slider_descriptioncolor',
				'slider_descriptionbrdcolor',
                'slider_btntxt1color',
				'slider_btnbgcolor',
				'slider_btntxthrvcolor'

            ),
     	),
		 array(
		   'name' => esc_html__('Layout', 'veterinary-clinic'),
		   'icon' => 'dashicons dashicons-layout',
		   'fields' => array(
			   'slider_section_width',
		   ),
		)
	    
    	),
	))); 


	

	// General Tab

	// Slider 1
	$wp_customize->add_setting( 
    	'slider1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider1',
		array(
		    'label'   		=> __('Slider 1','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		



	// Slider 2
	$wp_customize->add_setting(
    	'slider2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'slider2',
		array(
		    'label'   		=> __('Slider 2','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 3
	$wp_customize->add_setting(
    	'slider3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 5,
		)
	);	

	$wp_customize->add_control( 
		'slider3',
		array(
		    'label'   		=> __('Slider 3','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// Slider 4
	$wp_customize->add_setting(
    	'slider4',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 6,
		)
	);	

	$wp_customize->add_control( 
		'slider4',
		array(
		    'label'   		=> __('Slider 4','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);



	// Slider 5
	$wp_customize->add_setting(
    	'slider5',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider5',
		array(
		    'label'   		=> __('Slider 5','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);

	// Slider 6
	$wp_customize->add_setting(
    	'slider6',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'slider6',
		array(
		    'label'   		=> __('Slider 6','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);


	// Style setting

	// slider title Color
	$slidertitlecolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_titlecolor',
    	array(
			'default' => $slidertitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_titlecolor',
		array(
		    'label'   		=> __('Title Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// slider description Color
	$sliderdescriptioncolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_descriptioncolor',
    	array(
			'default' => $sliderdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider descriptionbrd Color
	$sliderdescriptionbrdcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_descriptionbrdcolor',
    	array(
			'default' => $sliderdescriptionbrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_descriptionbrdcolor',
		array(
		    'label'   		=> __('Description Border Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntxt1 Color
	$sliderbtntxt1color = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_btntxt1color',
    	array(
			'default' => $sliderbtntxt1color,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntxt1color',
		array(
		    'label'   		=> __('Button Text Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btnbg Color
	$sliderbtnbgcolor = esc_html__('#fff', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_btnbgcolor',
    	array(
			'default' => $sliderbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// slider btntxthrv Color
	$sliderbtntxthrvcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'slider_btntxthrvcolor',
    	array(
			'default' => $sliderbtntxthrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'slider_btntxthrvcolor',
		array(
		    'label'   		=> __('Button Text Hover Color','veterinary-clinic'),
		    'section'		=> 'slider_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// Slider Layout
	$wp_customize->add_setting('slider_section_width',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'veterinaryclinic_sanitize_choices',
    ));
    $wp_customize->add_control('slider_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','veterinary-clinic'),
        'choices' => array (
            'Box Width' => __('Box Width','veterinary-clinic'),
            'Full Width' => __('Full Width','veterinary-clinic')
        ),
        'section' => 'slider_setting',
    ));



	/*=========================================
	ourtreatment Section
	=========================================*/
	$wp_customize->add_section(
		'ourtreatment_setting', array(
			'title' => esc_html__( 'Our Treatment Section', 'veterinary-clinic' ),
			'priority' => 2,
			'panel' => 'veterinaryclinic_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('veterinaryclinic_ourtreatment_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new veterinaryclinic_Tab_Control($wp_customize, 'veterinaryclinic_ourtreatment_tabs', array(
	   'section' => 'ourtreatment_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'veterinary-clinic'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
            	'ourtreatment_disable_section',
				'ourtreatment_heading',
            	'ourtreatment1',
            	'ourtreatment2',
            	'ourtreatment3'
            ),
            'active' => true,
         ),
	      array(
            'name' => esc_html__('Style', 'veterinary-clinic'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
            	'ourtreatment_headingcolor',
            	'ourtreatment_headingbrdcolor',
            	'ourtreatment_boxtitlecolor',
            	'ourtreatment_boxtitlehrvcolor'
            ),
     	),
		 array(
		   'name' => esc_html__('Layout', 'veterinary-clinic'),
		   'icon' => 'dashicons dashicons-layout',
		   'fields' => array(
			   'ourtreatment_section_width',
		   ),
		)
	    
    	),
	))); 



	// General

	// hide show ourtreatment section
	$wp_customize->add_setting(
        'ourtreatment_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new veterinaryclinic_Toggle_Switch_Custom_Control(
            $wp_customize,
            'ourtreatment_disable_section',
            array(
                'settings'      => 'ourtreatment_disable_section',
                'section'       => 'ourtreatment_setting',
                'label'         => __( 'Disable Section', 'veterinary-clinic' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'veterinary-clinic' ),
                    'off' => __( 'No', 'veterinary-clinic' )
                ),
            )
        )
    );


    // ourtreatment_heading
	$wp_customize->add_setting(
    	'ourtreatment_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment_heading',
		array(
		    'label'   		=> __('Heading','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourtreatment 1
	$wp_customize->add_setting( 
    	'ourtreatment1',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment1',
		array(
		    'label'   		=> __('Our Treatment 1','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);		

	// ourtreatment 2
	$wp_customize->add_setting(
    	'ourtreatment2',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 2,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment2',
		array(
		    'label'   		=> __('Our Treatment 2','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// ourtreatment 3
	$wp_customize->add_setting(
    	'ourtreatment3',
    	array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment3',
		array(
		    'label'   		=> __('Our Treatment 3','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'dropdown-pages',
			'transport'         => $selective_refresh,
		)  
	);	


	// style

	// ourtreatment heading color
	$ourtreatmentheadingcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'ourtreatment_headingcolor',
    	array(
			'default' => $ourtreatmentheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment_headingcolor',
		array(
		    'label'   		=> __('Heading Color','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// ourtreatment headingbrd color
	$ourtreatmentheadingbrdcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'ourtreatment_headingbrdcolor',
    	array(
			'default' => $ourtreatmentheadingbrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment_headingbrdcolor',
		array(
		    'label'   		=> __('Heading Border Color','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// ourtreatment boxtitle color
	$ourtreatmentboxtitlecolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'ourtreatment_boxtitlecolor',
    	array(
			'default' => $ourtreatmentboxtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment_boxtitlecolor',
		array(
		    'label'   		=> __('Box Title Color','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	

	// ourtreatment boxtitlehrv color
	$ourtreatmentboxtitlehrvcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'ourtreatment_boxtitlehrvcolor',
    	array(
			'default' => $ourtreatmentboxtitlehrvcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 4,
		)
	);	

	$wp_customize->add_control( 
		'ourtreatment_boxtitlehrvcolor',
		array(
		    'label'   		=> __('Box Title Hover Color','veterinary-clinic'),
		    'section'		=> 'ourtreatment_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


		// Slider Layout
	$wp_customize->add_setting('ourtreatment_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'veterinaryclinic_sanitize_choices',
    ));
    $wp_customize->add_control('ourtreatment_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','veterinary-clinic'),
        'choices' => array (
            'Box Width' => __('Box Width','veterinary-clinic'),
            'Full Width' => __('Full Width','veterinary-clinic')
        ),
        'section' => 'ourtreatment_setting',
    ));


	

	/*=========================================
	aboutus Section
	=========================================*/
	$wp_customize->add_section(
		'aboutus_setting', array(
			'title' => esc_html__( 'AboutUs Section', 'veterinary-clinic' ),
			'priority' => 2,
			'panel' => 'veterinaryclinic_frontpage_sections',
		)
	);

	$wp_customize->add_setting('veterinaryclinic_aboutus_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new veterinaryclinic_Tab_Control($wp_customize, 'veterinaryclinic_aboutus_tabs', array(
	   'section' => 'aboutus_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'veterinary-clinic'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'aboutus_disable_section',
            	'aboutus_image',
            	'aboutus_heading',
				'aboutus_subtitle',
				'aboutus_title',
				'aboutus_list1',
				'aboutus_list2',
				'aboutus_list3',
				'aboutus_list4',
				'aboutus_list5',
            	'aboutus_readmorebtn_link'
            ),
            'active' => true,
		),
		array(
		'name' => esc_html__('Style', 'veterinary-clinic'),
		'icon' => 'dashicons dashicons-art',
		'fields' => array(
			'aboutus_headingcolor',
			'aboutus_headingbrdcolor1',
			'aboutus_headingbrdcolor2',
			'aboutus_subtitlecolor',
			'aboutus_titlecolor',
			'aboutus_listcolor',
			'aboutus_listiconcolor',
			'aboutus_btntextcolor',
			'aboutus_btnbgcolor',
			'aboutus_btntexthovercolor'
		),
     	),
		 array(
		   'name' => esc_html__('Layout', 'veterinary-clinic'),
		   'icon' => 'dashicons dashicons-layout',
		   'fields' => array(
			   'aboutus_section_width',
		   ),
		)

    	),
	))); 


	// hide show aboutus section
	$wp_customize->add_setting(
        'aboutus_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new veterinaryclinic_Toggle_Switch_Custom_Control(
            $wp_customize,
            'aboutus_disable_section',
            array(
                'settings'      => 'aboutus_disable_section',
                'section'       => 'aboutus_setting',
                'label'         => __( 'Disable Section', 'veterinary-clinic' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'veterinary-clinic' ),
                    'off' => __( 'No', 'veterinary-clinic' )
                ),
            )
        )
    );

	// aboutus_image
	$wp_customize->add_setting(
    	'aboutus_image',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'aboutus_image',
	        array(
			    'label'   		=> __('Image 1','veterinary-clinic'),
				'description'=> __('Image Size Should Be 685*824','veterinary-clinic'),
	            'section' => 'aboutus_setting',
	            'settings' => 'aboutus_image'
	        )
	    )
	);

	
	// aboutus_heading
	$wp_customize->add_setting(
    	'aboutus_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_heading',
		array(
		    'label'   		=> __('Heading','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_subtitle
	$wp_customize->add_setting(
    	'aboutus_subtitle',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitle',
		array(
		    'label'   		=> __('Sub Title','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// aboutus_title
	$wp_customize->add_setting(
    	'aboutus_title',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_title',
		array(
		    'label'   		=> __('Title','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list1
	$wp_customize->add_setting(
    	'aboutus_list1',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list1',
		array(
		    'label'   		=> __('List 1','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list2
	$wp_customize->add_setting(
    	'aboutus_list2',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list2',
		array(
		    'label'   		=> __('List 2','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list3
	$wp_customize->add_setting(
    	'aboutus_list3',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list3',
		array(
		    'label'   		=> __('List 3','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list4
	$wp_customize->add_setting(
    	'aboutus_list4',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list4',
		array(
		    'label'   		=> __('List 4','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_list5
	$wp_customize->add_setting(
    	'aboutus_list5',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_list5',
		array(
		    'label'   		=> __('List 5','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	

	// aboutus_readmorebtn_link
	$aboutusreadmorebtnlink = esc_html__('#', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_readmorebtn_link',
    	array(
			'default' => $aboutusreadmorebtnlink,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 7,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_readmorebtn_link',
		array(
		    'label'   		=> __('Read More Button Link','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);


	
	//style

	// aboutus heading Color
	$aboutusheadingcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_headingcolor',
    	array(
			'default' => $aboutusheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_headingcolor',
		array(
		    'label'   		=> __('Heading Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);
	
	// aboutus headingbrd Colo1r
	$aboutusheadingbrdcolor1 = esc_html__('#ff4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_headingbrdcolor1',
    	array(
			'default' => $aboutusheadingbrdcolor1,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_headingbrdcolor1',
		array(
		    'label'   		=> __('Heading Border Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus subheading Color
	$aboutussubheadingcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_subtitlecolor',
    	array(
			'default' => $aboutussubheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_subtitlecolor',
		array(
		    'label'   		=> __('Sub Title Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus description Color
	$aboutusdescriptioncolor = esc_html__('#ff4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_titlecolor',
    	array(
			'default' => $aboutusdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_titlecolor',
		array(
		    'label'   		=> __('Title Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	
	// aboutus list Color
	$aboutuslistcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_listcolor',
    	array(
			'default' => $aboutuslistcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_listcolor',
		array(
		    'label'   		=> __('List Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus listicon Color
	$aboutuslisticoncolor = esc_html__('#ff4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_listiconcolor',
    	array(
			'default' => $aboutuslisticoncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_listiconcolor',
		array(
		    'label'   		=> __('List Icon Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// aboutus btntext Color
	$aboutusbtntextcolor = esc_html__('#fff', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_btntextcolor',
    	array(
			'default' => $aboutusbtntextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btntextcolor',
		array(
		    'label'   		=> __('Button Text Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// aboutus btnbg Color 
	$aboutusbtnbgcolor = esc_html__('#ff4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_btnbgcolor',
    	array(
			'default' => $aboutusbtnbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btnbgcolor',
		array(
		    'label'   		=> __('Button BG Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);



	// aboutus btn hover Color
	$aboutusbtntexthovercolor = esc_html__('#000', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'aboutus_btntexthovercolor',
    	array(
			'default' => $aboutusbtntexthovercolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'aboutus_btntexthovercolor',
		array(
		    'label'   		=> __('Button Text Hover Color','veterinary-clinic'),
		    'section'		=> 'aboutus_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// Layout
	$wp_customize->add_setting('aboutus_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'veterinaryclinic_sanitize_choices',
    ));
    $wp_customize->add_control('aboutus_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','veterinary-clinic'),
        'choices' => array (
            'Box Width' => __('Box Width','veterinary-clinic'),
            'Full Width' => __('Full Width','veterinary-clinic')
        ),
        'section' => 'aboutus_setting',
    ));



    /*=========================================
	Blog Section
	=========================================*/
	$wp_customize->add_section(
		'blog_setting', array(
			'title' => esc_html__( 'Blog Section', 'veterinary-clinic' ),
			'priority' => 3,
			'panel' => 'veterinaryclinic_frontpage_sections',
		)
	);
	

	$wp_customize->add_setting('veterinaryclinic_blog_tabs', array(
	   'sanitize_callback' => 'wp_kses_post',
	));

	$wp_customize->add_control(new veterinaryclinic_Tab_Control($wp_customize, 'veterinaryclinic_blog_tabs', array(
	   'section' => 'blog_setting',
	   'priority' => 2,
	   'buttons' => array(
	      array(
         	'name' => esc_html__('General', 'veterinary-clinic'),
            'icon' => 'dashicons dashicons-welcome-write-blog',
            'fields' => array(
				'blog_disable_section',
            	'blog_heading'
            ),
            'active' => true,
         ), 
	      array(
            'name' => esc_html__('Style', 'veterinary-clinic'),
        	'icon' => 'dashicons dashicons-art',
            'fields' => array(
                'blog_headingcolor',
				'blog_headingbrdcolor',
                'blog_titlecolor',
                'blog_descriptioncolor',
                'blog_buttontextcolor',
				'blog_buttonbgcolor',
                'blog_authorandcategorycolor',
                'blog_authorandcategoryiconcolor',
				'blog_boxbrdcolor',
				'blog_boxbgcolor'

            ),
     	),
		 array(
		   'name' => esc_html__('Layout', 'veterinary-clinic'),
		   'icon' => 'dashicons dashicons-layout',
		   'fields' => array(
			   'blog_section_width',
		   ),
		)

    	),
	))); 


	// General Tab

	
	// hide show blog section
	$wp_customize->add_setting(
        'blog_disable_section',
        array(
            'sanitize_callback' => 'wp_kses_post',
        )
    ); 
    $wp_customize->add_control(
        new veterinaryclinic_Toggle_Switch_Custom_Control(
            $wp_customize,
            'blog_disable_section',
            array(
                'settings'      => 'blog_disable_section',
                'section'       => 'blog_setting',
                'label'         => __( 'Disable Section', 'veterinary-clinic' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'veterinary-clinic' ),
                    'off' => __( 'No', 'veterinary-clinic' )
                ),
            )
        )
    );

	// blog subheading Color
	$wp_customize->add_setting(
    	'blog_heading',
    	array(
			'default' => '',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 1,
		)
	);	

	$wp_customize->add_control( 
		'blog_heading',
		array(
		    'label'   		=> __('Heading','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'text',
			'transport'         => $selective_refresh,
		)  
	);	


	// Style setting

	// blog heading Color
	$blogheadingcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_headingcolor',
    	array(
			'default' => $blogheadingcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_headingcolor',
		array(
		    'label'   		=> __('Heading Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog headingbrd Color
	$blogheadingbrdcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_headingbrdcolor',
    	array(
			'default' => $blogheadingbrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_headingbrdcolor',
		array(
		    'label'   		=> __('Heading Border Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// blog title Color
	$blogtitlecolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_titlecolor',
    	array(
			'default' => $blogtitlecolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_titlecolor',
		array(
		    'label'   		=> __('Title Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog description Color
	$blogdescriptioncolor = esc_html__('#4B4B4B', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_descriptioncolor',
    	array(
			'default' => $blogdescriptioncolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_descriptioncolor',
		array(
		    'label'   		=> __('Description Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// blog buttontext Color
	$blogbuttontextcolor = esc_html__('#fff', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_buttontextcolor',
    	array(
			'default' => $blogbuttontextcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_buttontextcolor',
		array(
		    'label'   		=> __('Button Text Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog buttonbg Color
	$blogbuttonbgcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_buttonbgcolor',
    	array(
			'default' => $blogbuttonbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_buttonbgcolor',
		array(
		    'label'   		=> __('Button BG Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);


	// blog authorandcategory Color
	$blogauthorandcategorycolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_authorandcategorycolor',
    	array(
			'default' => $blogauthorandcategorycolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_authorandcategorycolor',
		array(
		    'label'   		=> __('Date & Category Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog authorandcategoryicon Color
	$blogauthorandcategoryiconcolor = esc_html__('#FF4880', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_authorandcategoryiconcolor',
    	array(
			'default' => $blogauthorandcategoryiconcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_authorandcategoryiconcolor',
		array(
		    'label'   		=> __('Date & Category Icon Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog midlebrd Color
	$blogmidlebrdcolor = esc_html__('#393D72', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_boxbrdcolor',
    	array(
			'default' => $blogmidlebrdcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_boxbrdcolor',
		array(
		    'label'   		=> __('Box Border Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// blog boxbg Color
	$blogboxbgcolor = esc_html__('#fff', 'veterinary-clinic' );
	$wp_customize->add_setting(
    	'blog_boxbgcolor',
    	array(
			'default' => $blogboxbgcolor,
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'wp_kses_post',
			'priority'      => 3,
		)
	);	

	$wp_customize->add_control( 
		'blog_boxbgcolor',
		array(
		    'label'   		=> __('Box BG Color','veterinary-clinic'),
		    'section'		=> 'blog_setting',
			'type' 			=> 'color',
			'transport'         => $selective_refresh,
		)  
	);

	// Layout
	$wp_customize->add_setting('blog_section_width',array(
        'default' => 'Box Width',
        'sanitize_callback' => 'veterinaryclinic_sanitize_choices',
    ));
    $wp_customize->add_control('blog_section_width',array(
        'type' => 'select',
        'label' => __('Section Width','veterinary-clinic'),
        'choices' => array (
            'Box Width' => __('Box Width','veterinary-clinic'),
            'Full Width' => __('Full Width','veterinary-clinic')
        ),
        'section' => 'blog_setting',
    ));

	

	$wp_customize->register_control_type('veterinaryclinic_Tab_Control');

}

add_action( 'customize_register', 'veterinaryclinic_blog_setting' );

// feature selective refresh
function veterinaryclinic_blog_section_partials( $wp_customize ){	
	// blog_title
	$wp_customize->selective_refresh->add_partial( 'blog_title', array(
		'selector'            => '.home-blog .title h6',
		'settings'            => 'blog_title',
		'render_callback'  => 'veterinaryclinic_blog_title_render_callback',
	
	) );
	
	// blog_subtitle
	$wp_customize->selective_refresh->add_partial( 'blog_subtitle', array(
		'selector'            => '.home-blog .title h2',
		'settings'            => 'blog_subtitle',
		'render_callback'  => 'veterinaryclinic_blog_subtitle_render_callback',
	
	) );
	
	// blog_description
	$wp_customize->selective_refresh->add_partial( 'blog_description', array(
		'selector'            => '.home-blog .title p',
		'settings'            => 'blog_description',
		'render_callback'  => 'veterinaryclinic_blog_description_render_callback',
	
	) );	
	}

add_action( 'customize_register', 'veterinaryclinic_blog_section_partials' );

// blog_title
function veterinaryclinic_blog_title_render_callback() {
	return get_theme_mod( 'blog_title' );
}

// blog_subtitle
function veterinaryclinic_blog_subtitle_render_callback() {
	return get_theme_mod( 'blog_subtitle' );
}

// feature description
function veterinaryclinic_blog_description_render_callback() {
	return get_theme_mod( 'blog_description' );
}


