<?php
function veterinaryclinic_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'veterinaryclinic_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'fff',
		'width'                  => 2000, 
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'veterinaryclinic_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'veterinaryclinic_custom_header_setup' );

if ( ! function_exists( 'veterinaryclinic_header_style' ) ) :

function veterinaryclinic_header_style() {
	$header_text_color = get_header_textcolor();

  	$blog_disable_section = esc_attr(get_theme_mod('blog_disable_section','YES'));
  	$ourtreatment_disable_section = esc_attr(get_theme_mod('ourtreatment_disable_section','YES'));
  	$aboutus_disable_section = esc_attr(get_theme_mod('aboutus_disable_section','YES'));


	?>
	<style type="text/css">


		<?php 
		
		?>


		header.site-header .site-title {
			color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?>;
		}

		header.site-header .site-logo a {
			text-decoration-color: <?php echo esc_attr(get_theme_mod('topheader_sitetitlecol')); ?> !important;
		}

		p.site-description {
			color: <?php echo esc_attr(get_theme_mod('topheader_taglinecol')); ?>;
		}
		


		
	
		header .tophead {
			background: <?php echo esc_attr(get_theme_mod('header_topheadbgcolor')); ?>;
		}

		header .tophead p {
			color: <?php echo esc_attr(get_theme_mod('header_topheadtextcolor')); ?>;
		}

		header .h_mail {
			color: <?php echo esc_attr(get_theme_mod('header_topheadmailiconcolor')); ?>;
		}

		header .socialicon a i {
			color: <?php echo esc_attr(get_theme_mod('header_topheadiconscolor')); ?>;
		}

		header .socialicon a:hover i {
			color: <?php echo esc_attr(get_theme_mod('header_topheadiconshovrcolor')); ?>;
		}

		header.site-header {
			background: <?php echo esc_attr(get_theme_mod('header_bgcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li a, .main-header .navbar .navbar-menu ul li.dropdown>a::after {
			color: <?php echo esc_attr(get_theme_mod('header_menuscolor')); ?>;
		}

		.main-header .navbar .navbar-nav > li:hover a, .main-header .navbar .navbar-nav > li.focus a, .main-header .navbar .navbar-nav > li.active a, .main-header .navbar .navbar-nav > li a.active,.main-header .navbar .navbar-menu ul li:hover.dropdown>a::after {
			color: <?php echo esc_attr(get_theme_mod('header_menushovercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			color: <?php echo esc_attr(get_theme_mod('header_submenutextcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a {
			background: <?php echo esc_attr(get_theme_mod('header_submenusbgcolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu a:not(.remove) {
			border-left-color: <?php echo esc_attr(get_theme_mod('header_submenusbordercolor')); ?>;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu li:hover a {
			background: <?php echo esc_attr(get_theme_mod('header_submenusbghovercolor')); ?> !important;
		}

		.main-header .navbar .navbar-menu ul li.dropdown .sub-menu li:hover a {
			color: <?php echo esc_attr(get_theme_mod('header_submenustxthovercolor')); ?> !important;
		}
	
		
		header a.contactus {
			color: <?php echo esc_attr(get_theme_mod('header_btntxtcolor')); ?>;
		}

		header a.contactus {
			background: <?php echo esc_attr(get_theme_mod('header_btnbgcolor')); ?>;
		}

		header a.contactus:hover {
			color: <?php echo esc_attr(get_theme_mod('header_btntxthrvcolor')); ?>;
		}
		




		.hero-style .slide-title h2 {
			color: <?php echo esc_attr(get_theme_mod('slider_titlecolor')); ?> !important;
		}


		.hero-style .slide-text p {
			color: <?php echo esc_attr(get_theme_mod('slider_descriptioncolor')); ?>;
		}

		.hero-style .slide-text svg path {
			stroke: <?php echo esc_attr(get_theme_mod('slider_descriptionbrdcolor')); ?>;
		}

		.hero-style a.ReadMore {
			color: <?php echo esc_attr(get_theme_mod('slider_btntxt1color')); ?> !important;
		}

		.hero-style a.ReadMore {
			background: <?php echo esc_attr(get_theme_mod('slider_btnbgcolor')); ?> !important;
		}

		.hero-style a.ReadMore:hover {
			color: <?php echo esc_attr(get_theme_mod('slider_btntxthrvcolor')); ?> !important;
		}

	
		/* Our Treatment */

		#ourtreatment-section .heading h2 {
			color: <?php echo esc_attr(get_theme_mod('ourtreatment_headingcolor')); ?>;
		}

		#ourtreatment-section .heading svg path{
			stroke: <?php echo esc_attr(get_theme_mod('ourtreatment_headingbrdcolor')); ?>;
		}

		#ourtreatment-section .ourtbx .single-ourtreatment h3 {
			color: <?php echo esc_attr(get_theme_mod('ourtreatment_boxtitlecolor')); ?>;
		}

		#ourtreatment-section .ourtbx .single-ourtreatment:hover h3 {
			color: <?php echo esc_attr(get_theme_mod('ourtreatment_boxtitlehrvcolor')); ?>;
		}




		/* about us */
		#aboutus-section .heading h3 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_headingcolor')); ?>;
		}

		#aboutus-section .abtheadbrd svg path {
			stroke: <?php echo esc_attr(get_theme_mod('aboutus_headingbrdcolor1')); ?>;
		}

		#aboutus-section .abt-dbx h4 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_subtitlecolor')); ?>;
		}

		#aboutus-section .abt-dbx h2 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_titlecolor')); ?>;
		}

		#aboutus-section .lists h4 {
			color: <?php echo esc_attr(get_theme_mod('aboutus_listcolor')); ?>;
		}

		#aboutus-section .lists h4 i {
			color: <?php echo esc_attr(get_theme_mod('aboutus_listiconcolor')); ?>;
		}

		#aboutus-section .abt-btn a {
			color: <?php echo esc_attr(get_theme_mod('aboutus_btntextcolor')); ?>;
		}

		#aboutus-section .abt-btn a {
			color: <?php echo esc_attr(get_theme_mod('aboutus_btntextcolor')); ?>;
		}

		#aboutus-section .abt-btn a {
			background: <?php echo esc_attr(get_theme_mod('aboutus_btnbgcolor')); ?>;
		}
#aboutus-section .abt-btn a:hover {
			color: <?php echo esc_attr(get_theme_mod('aboutus_btntexthovercolor')); ?>;
		}


		/* blog section */

		#blog-section h3.section-title {
			color: <?php echo esc_attr(get_theme_mod('blog_headingcolor')); ?>;
		}

		#blog-section .blogdbrd svg path {
			stroke: <?php echo esc_attr(get_theme_mod('blog_headingbrdcolor')); ?>;
		}


		.blogbx .blog-content h6.post-title, .blogbx .blog-content h6.post-title a, .blogbx .blog-content .heding {
			color: <?php echo esc_attr(get_theme_mod('blog_titlecolor')); ?>;
		}

		.blogbx .blog-content p {
			color: <?php echo esc_attr(get_theme_mod('blog_descriptioncolor')); ?>;
		}

		.blog-area .btn_blog a {
			color: <?php echo esc_attr(get_theme_mod('blog_buttontextcolor')); ?>;
		}

		.blog-area .btn_blog a {
			background: <?php echo esc_attr(get_theme_mod('blog_buttonbgcolor')); ?>;
		}

		.blogbx .blog-content .box-admin, .blogbx .blog-content .box-admin a, .blogbx .blog-content .box-date, .blogbx .blog-content .box-admin span {
			color: <?php echo esc_attr(get_theme_mod('blog_authorandcategorycolor')); ?>;
		}

		.blog-area .blog-content i {
			color: <?php echo esc_attr(get_theme_mod('blog_authorandcategoryiconcolor')); ?>;
		}

		.page-template-template-frontpage .blog-area .blog-content {
			border-color: <?php echo esc_attr(get_theme_mod('blog_boxbrdcolor')); ?>;
		}

		.page-template-template-frontpage .blog-area .blog-content {
			background: <?php echo esc_attr(get_theme_mod('blog_boxbgcolor')); ?>;
		}





		.copy-right p,.copy-right p a {
			color: <?php echo esc_attr(get_theme_mod('footer_copyrightcolor')); ?>;
		}

		.copy-right {
			border-color: <?php echo esc_attr(get_theme_mod('footer_copyrightbrdcolor')); ?>;
		}

		.footer-area .footer-widget .w-title {
			color: <?php echo esc_attr(get_theme_mod('footer_widgettilecolor')); ?>;
		}

		.footer-area .widget_text, .footer-area .widget_text p, .wp-block-latest-comments__comment-excerpt p, .wp-block-latest-comments__comment-date, .has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-excerpt, .has-avatars .wp-block-latest-comments__comment .wp-block-latest-comments__comment-meta,.footer-area .widget_block h1, .footer-area .widget_block h2, .footer-area .widget_block h3, .footer-area .widget_block h4, .footer-area .widget_block h5, .footer-area .widget_block h6,.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a {
			color: <?php echo esc_attr(get_theme_mod('footer_textcolor')); ?>;
		}

		.footer-area li:before, .page-template-home-template .footer-area li:before, .page .footer-area li:before, .single .footer-area li:before {
			color: <?php echo esc_attr(get_theme_mod('footer_iconcolor')); ?>;
		}

		.footer-area .footer-widget .widget:not(.widget_social_widget):not(.widget_tag_cloud) li a:hover {
			color: <?php echo esc_attr(get_theme_mod('footer_listhovercolor')); ?>;
		}

		.scroll-top i {
			color: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconcolor')); ?>;
		}

		.scroll-top {
			background: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconbgcolor')); ?>;
		}

		.scroll-top:hover {
			background: <?php echo esc_attr(get_theme_mod('footer_scrolltotopiconbghrvcolor')); ?>;
		}

		
	<?php  ?>


	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		.breadcrumb-section h1{
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>



	<?php
        if ($blog_disable_section == 1):
	?>
		#blog-section {
			display: none;
		}
	<?php
		else :
	?>
		#blog-section {
			display: block;
		}
	<?php endif; ?>


	<?php
        if ($ourtreatment_disable_section == 1):
	?>
		#newarrivalproduct-product-section {
			display: none;
		}
	<?php
		else :
	?>
		#newarrivalproduct-product-section {
			display: block;
		}
	<?php endif; ?>


	<?php
        if ($aboutus_disable_section == 1):
	?>
		#aboutus-section {
			display: none;
		}
	<?php
		else :
	?>
		#aboutus-section {
			display: block;
		}
	<?php endif; ?>



	</style>
	<?php
}
endif;
