<?php
// Global variables define
define('VDPERANTO_PARENT_TEMPLATE_DIR_URI', get_template_directory_uri());
define('VDPERANTO_TEMPLATE_DIR_URI', get_stylesheet_directory_uri());
define('VDPERANTO_TEMPLATE_DIR', trailingslashit(get_stylesheet_directory()));

if (!function_exists('wp_body_open')) {

    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }

}

//Enqueue script and style
add_action( 'wp_enqueue_scripts', 'vdperanto_theme_css',999);
function vdperanto_theme_css() {
    wp_enqueue_style( 'bootstrap-style', VDPERANTO_PARENT_TEMPLATE_DIR_URI . '/css/bootstrap.css' );
    wp_enqueue_style( 'vdperanto-parent-style', VDPERANTO_PARENT_TEMPLATE_DIR_URI . '/style.css' );
    wp_enqueue_style( 'vdperanto-child-style', get_stylesheet_uri(), array( 'vdperanto-parent-style' ) );
    wp_enqueue_style( 'vdperanto-custom-style-css', VDPERANTO_TEMPLATE_DIR_URI."/css/custom.css" );
    wp_dequeue_style( 'busiporf-custom-css', VDPERANTO_PARENT_TEMPLATE_DIR_URI.'/css/custom.css');
    //add script
    wp_enqueue_script('vdperanto-mp-masonry-js', VDPERANTO_TEMPLATE_DIR_URI . '/js/masonry/mp.mansory.min.js');
}

add_action( 'after_setup_theme', 'vdperanto' );
function vdperanto()
{
	load_theme_textdomain( 'vdperanto', VDPERANTO_TEMPLATE_DIR . '/languages' );

    require( VDPERANTO_TEMPLATE_DIR . '/functions/customizer/customizer-header-layout.php' );
    require( VDPERANTO_TEMPLATE_DIR . '/functions/customizer/customizer-blog-layout.php' );
    require( VDPERANTO_TEMPLATE_DIR . '/functions/template-tag.php' );

    //About Theme
    $theme = wp_get_theme(); // gets the current theme
    if ('vdperanto' == $theme->name) {
        if (is_admin()) {
            require VDPERANTO_TEMPLATE_DIR . '/admin/admin-init.php';
        }
    }

    add_theme_support('automatic-feed-links');
    add_theme_support('title-tag');
}


add_action( 'after_switch_theme', 'vdperanto_import_busiprof_theme_data_in_busiprof_child_theme' );
/**
* Import theme mods when switching from Busiprof child theme to Busiprof
*/
function vdperanto_import_busiprof_theme_data_in_busiprof_child_theme() {

    // Get the name of the previously active theme.
    $previous_theme = strtolower( get_option( 'theme_switched' ) );

    if ( ! in_array(
        $previous_theme, array(
            'busiprof',
			'vdequator',
			'arzine',
			'lazyprof',
        )
    ) ) {
        return;
    }

    // Get the theme mods from the previous theme.
    $previous_theme_content = get_option( 'theme_mods_' . $previous_theme );

    if ( ! empty( $previous_theme_content ) ) {
        foreach ( $previous_theme_content as $previous_theme_mod_k => $previous_theme_mod_v ) {
            set_theme_mod( $previous_theme_mod_k, $previous_theme_mod_v );
        }
    }
}

// Add masonry blog layout
add_action('wp_footer', 'vdperanto_custom_script');
function vdperanto_custom_script() {
$vdperanto_options = wp_parse_args(get_option('busiprof_theme_options', array()), vdperanto_default_data());
if ($vdperanto_options['blog_masonry3_layout_setting'] == 'masonry3') {
    wp_reset_query();
    $col = 4;?>
    <script>
        jQuery(document).ready(function (jQuery) {
            jQuery("#blog-masonry").mpmansory(
                    {
                        childrenClass: 'masonry-item', // default is a div
                        columnClasses: 'padding', //add classes to items
                        breakpoints: {
                            lg: 4, //Change masonry column here like 2, 3, 4 column
                            md: 6,
                            sm: 12,
                            xs: 12
                        },
                        distributeBy: {order: false, height: false, attr: 'data-order', attrOrder: 'asc'}, //default distribute by order, options => order: true/false, height: true/false, attr => 'data-order', attrOrder=> 'asc'/'desc'
                        onload: function (items) {
                            //make somthing with items
                        }
                    }
            );
        });
    </script>
    <!-- <style type="text/css">
        .col-md-6:nth-child(2n+1) {
            clear: none;
        }
    </style> -->
    <?php
}
}

//Set for old user
if (!get_option('busiprof_user', false)) {
     //detect old user and set value
    $vdperanto_user = get_option('busiprof_theme_options', array());
    if ((isset($vdperanto_user['service_heading_one']) || isset($vdperanto_user['service_tagline']) || isset($vdperanto_user['recent_blog_title']) || isset($vdperanto_user['recent_blog_description']))) {
        add_option('busiprof_user', 'old');
    }else{
        add_option('busiprof_user', 'new');
    }
}
function vdperanto_default_data(){
    $vdperanto_current_options = wp_parse_args(get_option('busiprof_theme_options', array()), busiprof_theme_setup_data());
        if (get_option('busiprof_user', 'new')=='old' || $vdperanto_current_options['upload_image'] != '') {

            $array_new = array(
                'header_sticky_layout_setting' => 'default',
                'service_blink_effect_layout_setting' => 'default',
                'blog_masonry3_layout_setting' => 'default',
                'testimonial_center_effect_layout_setting'=>'default',
            );
        }
        else{
            $array_new = array(
                'header_sticky_layout_setting' => 'sticky',
                'service_blink_effect_layout_setting' => 'blink_effect',
                'blog_masonry3_layout_setting' => 'masonry3',
                'testimonial_center_effect_layout_setting'=>'center_box_effect',
            );
        }
        return array_merge($array_new, $vdperanto_current_options);
}

// Add script for sticky header
add_action('wp_head', 'vdperanto_sticky_header');
function vdperanto_sticky_header() {
    $vdperanto_options = wp_parse_args(get_option('busiprof_theme_options', array()), vdperanto_default_data());
    if ($vdperanto_options['header_sticky_layout_setting'] == 'sticky') {
        ?>
        <script>
            jQuery(document).ready(function (jQuery) {
                jQuery(window).bind('scroll', function () {
                    if (jQuery(window).scrollTop() > 200) {
                        jQuery('.navbar').addClass('stickymenu1');
                        jQuery('.navbar').slideDown();
                    } else {
                        jQuery('.navbar').removeClass('stickymenu1');
                        jQuery('.navbar').attr('style', '');
                    }
                });
            });
        </script>
        <?php

    }
}
function vdperanto_header_page_style(){
  $vdperanto_options = wp_parse_args(get_option('busiprof_theme_options', array()), vdperanto_default_data());
  if ($vdperanto_options['header_sticky_layout_setting'] == 'sticky') {?>
    <style>
    .page-header {
        padding: 120px 18px 18px;
    }
    </style>
  <?php
  }
}
add_action('wp_head','vdperanto_header_page_style');

$vdperanto_theme = wp_get_theme();
if( $vdperanto_theme->name == 'vdperanto' || $vdperanto_theme->name == 'vdperanto child' || $vdperanto_theme->name == 'vdperanto Child') {
    // Notice to add required plugin
    function vdperanto_admin_plugin_notice_warn() {
        global $hook_suffix;
        $theme_name = wp_get_theme();
        if($hook_suffix === 'themes.php'){
            if ( get_option( 'dismissed-vdperanto_comanion_plugin', false ) ) {
               return;
            }
            if ( function_exists('webriti_companion_activate')) {
                return;
            }?>
            <div class="updated notice is-dismissible vdperanto-theme-notice">

                <div class="owc-header">
                    <h2 class="theme-owc-title">               
                        <svg height="60" width="60" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 70"><defs><style>.cls-1{font-size:33px;font-family:Verdana-Bold, Verdana;font-weight:700;}</style></defs><title>Artboard 1</title><text class="cls-1" transform="translate(-0.56 51.25)">WC</text></svg>
                        <?php echo esc_html('Webriti Companion','vdperanto');?>
                    </h2>
                </div>
                <div class="vdperanto-theme-content">
                    <h3><?php printf (esc_html__('Thank you for installing the %1$s theme.', 'vdperanto'), esc_html($theme_name)); ?></h3>

                    <p><?php esc_html_e( 'We highly recommend you to install and activate the', 'vdperanto' ); ?>
                        <b><?php esc_html_e( 'Webriti Companion', 'vdperanto' ); ?></b> plugin.
                        <br>
                        <?php esc_html_e( 'This plugin will unlock enhanced features to build a beautiful website.', 'vdperanto' ); ?>
                    </p>
                    <button id="install-plugin-button-welcome-page" data-plugin-url="<?php echo esc_url( 'https://webriti.com/extensions/webriti-companion.zip');?>"><?php echo esc_html__( 'Install', 'vdperanto' ); ?></button>
                </div>
            </div>
            
            <script type="text/javascript">
                jQuery(function($) {
                $( document ).on( 'click', '.vdperanto-theme-notice .notice-dismiss', function () {
                    var type = $( this ).closest( '.vdperanto-theme-notice' ).data( 'notice' );
                    $.ajax( ajaxurl,
                      {
                        type: 'POST',
                        data: {
                          action: 'dismissed_notice_handler',
                          type: type,
                        }
                      } );
                  } );
              });
            </script>
            <style>
                .vdperanto-theme-notice .theme-owc-title{
                    display: flex;
                    align-items: center;
                    height: 100%;
                    margin: 0;
                    font-size: 1.5em;
                }
                .vdperanto-theme-notice p{
                    font-size: 14px;
                }
                .updated.notice.vdperanto-theme-notice h3{
                    margin: 0;
                }
                div.vdperanto-theme-notice.updated {
                    border-left-color: #ee591f;
                }
                .vdperanto-theme-content{
                    padding: 0 0 1.2rem 3.57rem;
                }
            </style>
       <?php
        }
    }
    add_action( 'admin_notices', 'vdperanto_admin_plugin_notice_warn' );
    add_action( 'wp_ajax_dismissed_notice_handler', 'vdperanto_ajax_notice_handler');

    function vdperanto_ajax_notice_handler() {
        update_option( 'dismissed-vdperanto_comanion_plugin', TRUE );
    }
}

// Hook the AJAX action for logged-in users
add_action('wp_ajax_vdperanto_check_plugin_status', 'vdperanto_check_plugin_status');

function vdperanto_check_plugin_status() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to manage plugins.');
        return;
    }

    if (!isset($_POST['plugin_slug'])) {
        wp_send_json_error('No plugin slug provided.');
        return;
    }

    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Adjust this based on your plugin structure

    // Check if the plugin exists
    $plugins = get_plugins();
    if (isset($plugins[$plugin_main_file])) {
        if (is_plugin_active($plugin_main_file)) {
            wp_send_json_success(array('status' => 'activated'));
        } else {
            wp_send_json_success(array('status' => 'installed'));
        }
    } else {
        wp_send_json_success(array('status' => 'not_installed'));
    }
}

// Existing AJAX installation function for installing and activating
add_action('wp_ajax_vdperanto_install_activate_plugin', 'vdperanto_install_and_activate_plugin');

function vdperanto_install_and_activate_plugin() {
    if (!current_user_can('install_plugins')) {
        wp_send_json_error('You do not have permission to install plugins.');
        return;
    }

    if (!isset($_POST['plugin_url'])) {
        wp_send_json_error('No plugin URL provided.');
        return;
    }

    // Include necessary WordPress files for plugin installation
    include_once(ABSPATH . 'wp-admin/includes/file.php');
    include_once(ABSPATH . 'wp-admin/includes/misc.php');
    include_once(ABSPATH . 'wp-admin/includes/class-wp-upgrader.php');
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');

    $plugin_url = esc_url($_POST['plugin_url']);
    $plugin_slug = sanitize_text_field($_POST['plugin_slug']);
    $plugin_main_file = $plugin_slug . '/' . $plugin_slug . '.php'; // Ensure this matches your plugin structure

    // Download the plugin file
    WP_Filesystem();
    $temp_file = download_url($plugin_url);

    if (is_wp_error($temp_file)) {
        wp_send_json_error($temp_file->get_error_message());
        return;
    }

    // Unzip the plugin to the plugins folder
    $plugin_folder = WP_PLUGIN_DIR;
    $result = unzip_file($temp_file, $plugin_folder);
    
    // Clean up temporary file
    unlink($temp_file);

    if (is_wp_error($result)) {
        wp_send_json_error($result->get_error_message());
        return;
    }

    // Activate the plugin if it was installed
    $activate_result = activate_plugin($plugin_main_file);

    

    // Return success with redirect URL
    wp_send_json_success(array('redirect_url' => admin_url('admin.php?page=vdperanto-welcome')));
}

// Enqueue JavaScript for the button functionality
add_action('admin_enqueue_scripts', 'vdperanto_enqueue_plugin_installer_script');

function vdperanto_enqueue_plugin_installer_script() {
    global $hook_suffix;
    wp_dequeue_script('busiprof-plugin-installer-js');    
    wp_enqueue_script('vdperanto-plugin-installer-js',  VDPERANTO_TEMPLATE_DIR_URI . '/admin/assets/js/plugin-installer.js', array('jquery'), null, true);
    wp_localize_script('vdperanto-plugin-installer-js', 'pluginInstallerAjax', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'hook_suffix' => $hook_suffix,
        'nonce' => wp_create_nonce('plugin_installer_nonce'),
    ));
}
