<?php

/*-----------------------------------------------------------------------------------*/
/* Enqueu scripts */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagante_enqueue_scripts')) {

	function vagante_enqueue_scripts() {

		wp_deregister_style( 'avventura-lite-style' );
		wp_deregister_style( 'avventura-lite-' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')) );

		wp_enqueue_style( 'avventura-lite-parent-style' , get_template_directory_uri() . '/style.css' ); 

		wp_enqueue_style(
			'vagante-' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')),
			get_stylesheet_directory_uri() . '/assets/skins/' . esc_attr(get_theme_mod('avventura_lite_skin', 'orange')) . '.css',
			array( 'vagante-style' ),
			'1.0.0'
		); 

		wp_enqueue_style( 'vagante-style' , get_stylesheet_directory_uri() . '/style.css' ); 

		$googleFontsArgs = array(
			'family' =>	str_replace('|', '%7C','Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i'),
			'subset' =>	'latin,latin-ext'
		);
		
		wp_deregister_style('google-fonts');
		wp_enqueue_style('google-fonts', add_query_arg ( $googleFontsArgs, "https://fonts.googleapis.com/css" ), array(), '1.0.0' );

		wp_enqueue_script(
			'vagante-script',
			get_stylesheet_directory_uri() . '/assets/js/script.js',
			array('jquery'),
			'1.0.0', 
			TRUE
		);

	}
	
	add_action( 'wp_enqueue_scripts', 'vagante_enqueue_scripts', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Replace hooks */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagante_replace_hooks')) {

	function vagante_replace_hooks() {

		remove_action( 'avventura_lite_top_sidebar', 'avventura_lite_top_sidebar_function' );
		remove_action( 'avventura_lite_header_sidebar', 'avventura_lite_header_sidebar_function' );

		remove_action( 'avventura_lite_slick_slider', 'avventura_lite_slick_slider_function', 10, 2);

		remove_action( 'avventura_lite_thumbnail', 'avventura_lite_thumbnail_function');
		remove_action( 'avventura_lite_before_content', 'avventura_lite_before_content_function' );
		remove_action( 'avventura_lite_after_content', 'avventura_lite_after_content_function' );
		
		remove_action( 'avventura_lite_default_format', 'avventura_lite_default_format_function' );
		remove_action( 'avventura_lite_image_format', 'avventura_lite_image_format_function' );
		remove_action( 'avventura_lite_page_format', 'avventura_lite_page_format_function' );
		
	}
	
	add_action('init','vagante_replace_hooks');

}

/*-----------------------------------------------------------------------------------*/
/* Customize register */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagante_customize_register')) {

	function vagante_customize_register( $wp_customize ) {

		$wp_customize->remove_section( 'slideshow_section');

		$wp_customize->remove_control( 'avventura_lite_header_layout');
		$wp_customize->remove_control( 'avventura_lite_homepage_slideshow');
		$wp_customize->remove_control( 'avventura_lite_slideshow_limit');
		$wp_customize->remove_control( 'avventura_lite_homepage_slideshow_position');
		$wp_customize->remove_control( 'avventura_lite_slideshow_post_category');
		$wp_customize->remove_control( 'avventura_lite_slideshow_post_details');
		$wp_customize->remove_control( 'avventura_lite_slideshow_overlay');
		$wp_customize->remove_control( 'avventura_lite_post_icon');

		$wp_customize->add_setting( 'vagante_logo_text_color', array(
			'default' => '#ffffff',
			'sanitize_callback' => 'sanitize_hex_color',
		));

		$wp_customize->add_control( 'vagante_logo_text_color' , array(
			'type' => 'color',
			'section' => 'colors',
			'label' => esc_html__('Logo text color','vagante'),
			'description' => esc_html__('Choose your custom color for the logo.','vagante'),
		));
		
		$wp_customize->add_setting( 'vagante_textlogo_border', array(
			'default' => 'on',
			'sanitize_callback' => 'vagante_select_sanitize',
		));

		$wp_customize->add_control( 'vagante_textlogo_border' , array(
			'priority' => '09',
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Text logo border', 'vagante'),
			'description' => esc_html__('Do you want to display the border around the text logo?', 'vagante'),
			'choices'  => array (
				'off' => esc_html__( 'No',   'vagante'),
				'on' => esc_html__( 'Yes', 'vagante'),
			),
		));

		$wp_customize->add_setting( 'vagante_post_date', array(
			'default' => 'on',
			'sanitize_callback' => 'vagante_select_sanitize',
		));

		$wp_customize->add_control( 'vagante_post_date' , array(
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Post date', 'vagante'),
			'description' => esc_html__('Do you want to display the post date?', 'vagante'),
			'choices'  => array (
				'off' => esc_html__( 'No',   'vagante'),
				'on' => esc_html__( 'Yes', 'vagante'),
			),
		));

		$wp_customize->add_setting( 'vagante_post_author', array(
			'default' => 'on',
			'sanitize_callback' => 'vagante_select_sanitize',
		));

		$wp_customize->add_control( 'vagante_post_author' , array(
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Post author', 'vagante'),
			'description' => esc_html__('Do you want to display the post author?', 'vagante'),
			'choices'  => array (
				'off' => esc_html__( 'No',   'vagante'),
				'on' => esc_html__( 'Yes', 'vagante'),
			),
		));

		$wp_customize->add_control( 'avventura_lite_post_icon' , array(
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Post icon', 'vagante'),
			'description' => esc_html__('Do you want to display the post icon?', 'vagante'),
			'choices'  => array (
				'off' => esc_html__( 'No',   'vagante'),
				'on' => esc_html__( 'Yes', 'vagante'),
			),
		));

		$wp_customize->add_setting( 'vagante_post_category', array(
			'default' => 'on',
			'sanitize_callback' => 'vagante_select_sanitize',
		));

		$wp_customize->add_control( 'vagante_post_category' , array(
			'type' => 'select',
			'section' => 'settings_section',
			'label' => esc_html__('Post category', 'vagante'),
			'description' => esc_html__('Do you want to display the post category?', 'vagante'),
			'choices'  => array (
				'off' => esc_html__( 'No',   'vagante'),
				'on' => esc_html__( 'Yes', 'vagante'),
			),
		));

		$wp_customize->add_section('vagante_featured_area_section', array(
		  'title' => esc_html__( 'Featured area section', 'vagante' ),
		  'panel' => 'general_panel',
		  'priority' => 13,
		));
	
		$wp_customize->add_setting( 'vagante_featured_area', array(
			'default' => 'on',
			'sanitize_callback' => 'vagante_select_sanitize',

		));

		$wp_customize->add_control( 'vagante_featured_area' , array(
			'type' => 'select',
			'priority' => '09',
			'section' => 'vagante_featured_area_section',
			'label' => esc_html__('Sticky post grid','vagante'),
			'description' => esc_html__('Do you want to enable the featured area section on homepage?.','vagante'),
			'choices'  => array (
			   'off' => esc_html__( 'No','vagante'),
			   'on' => esc_html__( 'Yes','vagante'),
			),
		));
		
		function vagante_select_sanitize ($value, $setting) {
		
			global $wp_customize;
					
			$control = $wp_customize->get_control( $setting->id );
				 
			if ( array_key_exists( $value, $control->choices ) ) {
					
				return $value;
					
			} else {
					
				return $setting->default;
					
			}
			
		}

	}
	
	add_action( 'customize_register', 'vagante_customize_register', 11 );

}

/*-----------------------------------------------------------------------------------*/
/* Theme setup */
/*-----------------------------------------------------------------------------------*/ 

if (!function_exists('vagante_theme_setup')) {

	function vagante_theme_setup() {

		load_child_theme_textdomain( 'vagante', get_stylesheet_directory() . '/languages' );
		
		require_once( trailingslashit( get_stylesheet_directory() ) . 'core/functions/function-style.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/default-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/image-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/post-formats/page-format.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/sidebars/top-sidebar.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/sidebars/header-sidebar.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/before-content.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/after-content.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/post-icon.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/media.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/slick-slider.php' );
		require_once( trailingslashit( get_stylesheet_directory() ) . '/core/templates/featured-posts.php' );

		remove_theme_support( 'custom-logo');

		$defaults = array(
			'header-text' => array(
				'site-title',
				'site-description'
			)
		);
		
		add_theme_support( 'custom-logo', $defaults );

		register_default_headers( array(
			'default-image' => array(
				'url'           => get_stylesheet_directory_uri() . '/assets/images/header/header.jpg',
				'thumbnail_url' => get_stylesheet_directory_uri() . '/assets/images/header/resized-header.jpg',
				'description'   => esc_html__( 'Default image', 'vagante' )
			),
		));

		add_theme_support( 'custom-header', array( 
			'width'         => 1170,
			'height'        => 260,
			'default-image' => get_stylesheet_directory_uri() . '/assets/images/header/header.jpg',
			'header-text' 	=> false
		));

		remove_image_size( 'avventura_lite_slick_large', 960, 600, TRUE );
		remove_image_size( 'avventura_lite_slick_small', 400, 400, TRUE );

		add_image_size( 'vagante_slick_large', 679, 453, TRUE );
	
	}

	add_action( 'after_setup_theme', 'vagante_theme_setup', 999);

}

/*-----------------------------------------------------------------------------------*/
/* Exclude featured posts on homepage */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagante_exclude_featured_posts')) {

	function vagante_exclude_featured_posts(&$query) {
		
		if ( 
			$query->is_home() && 
			$query->is_main_query() &&
			avventura_lite_setting('vagante_featured_area','on') == 'on'
		) {
	
			$offset = 7;
			
			$ppp = get_option('posts_per_page');
		
			if ( $query->is_paged ) {
				
				$page_offset = $offset + ( ($query->query_vars['paged']-1) * $ppp );
				$query->set('offset', $page_offset );
		
			}
			else {
				$query->set('offset',$offset);
			}
	
		}
	
	}

	add_action('pre_get_posts', 'vagante_exclude_featured_posts', 1 );

}

/*-----------------------------------------------------------------------------------*/
/* Adjust offset pagination */
/*-----------------------------------------------------------------------------------*/   

if (!function_exists('vagante_adjust_offset_pagination')) {

	function vagante_adjust_offset_pagination($found_posts, $query) {
	
		$offset = 7;
	
		if ( 
			$query->is_home() && 
			avventura_lite_setting('vagante_featured_area','on') == 'on'
		) {
			return $found_posts - $offset;
		}
		
		return $found_posts;
	
	}

	add_filter('found_posts', 'vagante_adjust_offset_pagination', 1, 2 );

}

?>