<?php

/**
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * It is also available at this URL: http://www.gnu.org/licenses/gpl-3.0.txt
 */

if (!function_exists('vagante_sticky_posts_function')) {

	function vagante_sticky_posts_function() {

		$isFeaturedSection = ( ( is_home() || is_front_page() ) && avventura_lite_setting('vagante_featured_area', 'on') == 'on' ) ? TRUE : FALSE;

		if ( $isFeaturedSection ) : 

	?>
		
        <section class="featured-posts-main-wrapper">
        
            <div id="featured-posts-container" class="container-fluid">
                
                <div class="row">
                    
                    <div class="col-md-7">
                    
                        <?php do_action('vagante_slick_slider');?>
                    
                    </div>
                    
                    <div class="col-md-5">
                        
                        <div class="featured-posts-wrapper">
            
                        <?php

							$args = array(
								'post_type' => 'post',
								'posts_per_page' => 4,
								'offset' => 3,
								'orderby' => 'date',
								'order'	 => 'DESC',
								'ignore_sticky_posts' => true
							);
					
							$query = new WP_Query($args); 

							if ($query->have_posts()) : while ( $query->have_posts() ) : $query->the_post(); 
            
                                global $post;
                                
                                $thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large');
    
                                $featuredPostsStyle = (isset($thumb[0])) ? 'style="background-image: url(' . esc_url($thumb[0]) . ')"' : '';
    
                        ?>
    
                                <div class="featured-post featured-post-<?php echo $query->current_post?>" <?php echo $featuredPostsStyle;?> >
                                
                                    <a title="<?php echo esc_attr(get_the_title());?>" class="featured-post-permalink" href="<?php echo esc_url(get_permalink($post->ID)); ?>" ></a>
                        
                                    <h2 class="title"><?php echo esc_html(get_the_title()); ?></h2>
                
                                </div>
                
                            <?php
    
                                endwhile; 
                                endif;
                                wp_reset_postdata();
    
                            ?>
    
    
                        <div class="clear"></div>
    
                        </div>        
    
                    </div>        
    
                </div>    
    
            </div>        
				
    	</section>
        
	<?php 
	
		endif;
		
	}

	add_action( 'vagante_sticky_posts', 'vagante_sticky_posts_function' );

}

?>