<?php $featured_title = get_theme_mod( 'updated_news_banner_featured_posts_title', __( 'Featured Posts', 'updated-news' ) ); ?>
<!-- Featured Posts -->
<div class="featured-posts">
	<?php if ( ! empty( $featured_title ) ) : ?>
		<div class="widget-header">
			<h3 class="widget-title"><?php echo esc_html( $featured_title ); ?></h3>			
		</div>
	<?php endif; ?>
	<div class="featured-posts-wrapper">
		<?php
		$featured_posts_query = new WP_Query( $featured_posts_args );
		if ( $featured_posts_query->have_posts() ) {
			while ( $featured_posts_query->have_posts() ) :
				$featured_posts_query->the_post();
				?>
				<div class="post-item post-list">
					<?php if ( has_post_thumbnail() ) : ?>
						<div class="post-item-image">
							<a href="<?php the_permalink(); ?>">
								<?php the_post_thumbnail(); ?>							
							</a>
						</div>
					<?php endif; ?>
					<div class="post-item-content">
						<h2 class="entry-title">
							<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
						</h2>
					</div>   
				</div>
				<?php
			endwhile;
			wp_reset_postdata();
		}
		?>
	</div>
</div>
<!-- End Featured Posts -->
