<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'updated_news_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'updated-news' ),
		'panel' => 'updated_news_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'updated_news_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'updated-news' ),
			'settings' => 'updated_news_enable_single_category',
			'section'  => 'updated_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'updated_news_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'updated-news' ),
			'settings' => 'updated_news_enable_single_author',
			'section'  => 'updated_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'updated_news_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'updated-news' ),
			'settings' => 'updated_news_enable_single_date',
			'section'  => 'updated_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'updated_news_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'updated-news' ),
			'settings' => 'updated_news_enable_single_tag',
			'section'  => 'updated_news_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'updated_news_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'updated-news' ),
		'section'  => 'updated_news_single_page_options',
		'settings' => 'updated_news_related_posts_title',
	)
);
