<?php
/**
 * Sidebar settings.
 */

$wp_customize->add_section(
	'updated_news_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'updated-news' ),
		'panel' => 'updated_news_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'updated_news_sidebar_position',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'updated_news_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'updated-news' ),
		'section' => 'updated_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'updated-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'updated-news' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'updated_news_post_sidebar_position',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'updated_news_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'updated-news' ),
		'section' => 'updated_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'updated-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'updated-news' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'updated_news_page_sidebar_position',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'updated_news_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'updated-news' ),
		'section' => 'updated_news_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'updated-news' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'updated-news' ),
		),
	)
);
