<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'updated_news_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'updated-news' ),
		'panel' => 'updated_news_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'updated_news_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'updated-news' ),
			'settings' => 'updated_news_pagination_enable',
			'section'  => 'updated_news_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'updated_news_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'updated-news' ),
		'section'         => 'updated_news_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default'  => __( 'Default (Older/Newer)', 'updated-news' ),
			'numeric'  => __( 'Numeric', 'updated-news' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'updated_news_pagination_enable' )->value() );
		},
	)
);
