<?php
/**
 * Header Options settings
 */

$wp_customize->add_section(
	'updated_news_header_options_section',
	array(
		'title' => esc_html__( 'Header Options', 'updated-news' ),
		'panel' => 'updated_news_theme_options_panel',
	)
);

// Header button label setting.
$wp_customize->add_setting(
	'updated_news_header_button_label',
	array(
		'default'           => __( 'Subscription', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_header_button_label',
	array(
		'label'    => esc_html__( 'Header Button Label', 'updated-news' ),
		'section'  => 'updated_news_header_options_section',
		'settings' => 'updated_news_header_button_label',
		'type'     => 'text',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'updated_news_header_button_label',
		array(
			'selector'            => '.adore-header .adore-custom-btn i',
			'settings'            => 'updated_news_header_button_label',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Header button URL setting.
$wp_customize->add_setting(
	'updated_news_header_button_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'updated_news_header_button_url',
	array(
		'label'    => esc_html__( 'Header Button URL', 'updated-news' ),
		'section'  => 'updated_news_header_options_section',
		'settings' => 'updated_news_header_button_url',
		'type'     => 'url',
	)
);

	// Header - Fontawesome Icon.
$wp_customize->add_setting(
	'updated_news_counter_fontawesome_icon',
	array(
		'default'           => 'fa-solid fa-bell',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_counter_fontawesome_icon',
	array(
		'label'           => esc_html__( 'Fontawesome Icon %d', 'updated-news' ),
		'description'     => sprintf( '<a href=" ' . esc_url( 'https://fontawesome.com/search?o=r&m=free' ) . ' " target="_blank"> %1$s </a> %2$s', esc_html__( 'Click Here ', 'updated-news' ), esc_html__( ' for select fontawesome icon.', 'updated-news' ) ),
		'section'         => 'updated_news_header_options_section',
		'settings'        => 'updated_news_counter_fontawesome_icon',
		'type'            => 'text',
	)
);
