<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'updated_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'updated-news' ),
		'panel' => 'updated_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'updated_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'updated-news' ),
			'type'     => 'checkbox',
			'settings' => 'updated_news_breadcrumb_enable',
			'section'  => 'updated_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'updated_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'updated_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'updated-news' ),
		'section'         => 'updated_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'updated_news_breadcrumb_enable' )->value() );
		},
	)
);
