<?php
/**
 * Adore Themes Customizer
 *
 * @package Updated News
 *
 * Breaking News Section
 */

$wp_customize->add_section(
	'updated_news_breaking_news_section',
	array(
		'title' => esc_html__( 'Breaking News Section', 'updated-news' ),
		'panel' => 'updated_news_frontpage_panel',
	)
);

// Breaking News section enable settings.
$wp_customize->add_setting(
	'updated_news_breaking_news_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_breaking_news_section_enable',
		array(
			'label'    => esc_html__( 'Enable Breaking News Section', 'updated-news' ),
			'type'     => 'checkbox',
			'settings' => 'updated_news_breaking_news_section_enable',
			'section'  => 'updated_news_breaking_news_section',
		)
	)
);

// Breaking News title settings.
$wp_customize->add_setting(
	'updated_news_breaking_news_title',
	array(
		'default'           => __( 'Breaking News', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_breaking_news_title',
	array(
		'label'           => esc_html__( 'Title', 'updated-news' ),
		'section'         => 'updated_news_breaking_news_section',
		'active_callback' => 'updated_news_if_breaking_news_enabled',
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'updated_news_breaking_news_title',
		array(
			'selector'            => '.news-ticker-section .theme-wrapper',
			'settings'            => 'updated_news_breaking_news_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
			'render_callback'     => 'updated_news_breaking_news_title_text_partial',
		)
	);
}

// breaking_news content type settings.
$wp_customize->add_setting(
	'updated_news_breaking_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_breaking_news_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'updated-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'updated-news' ),
		'section'         => 'updated_news_breaking_news_section',
		'type'            => 'select',
		'active_callback' => 'updated_news_if_breaking_news_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'updated-news' ),
			'category' => esc_html__( 'Category', 'updated-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// breaking_news post setting.
	$wp_customize->add_setting(
		'updated_news_breaking_news_post_' . $i,
		array(
			'sanitize_callback' => 'updated_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'updated_news_breaking_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'updated-news' ), $i ),
			'section'         => 'updated_news_breaking_news_section',
			'type'            => 'select',
			'choices'         => updated_news_get_post_choices(),
			'active_callback' => 'updated_news_breaking_news_section_content_type_post_enabled',
		)
	);

}

// breaking_news category setting.
$wp_customize->add_setting(
	'updated_news_breaking_news_category',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_breaking_news_category',
	array(
		'label'           => esc_html__( 'Category', 'updated-news' ),
		'section'         => 'updated_news_breaking_news_section',
		'type'            => 'select',
		'choices'         => updated_news_get_post_cat_choices(),
		'active_callback' => 'updated_news_breaking_news_section_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function updated_news_if_breaking_news_enabled( $control ) {
	return $control->manager->get_setting( 'updated_news_breaking_news_section_enable' )->value();
}
function updated_news_breaking_news_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_breaking_news_content_type' )->value();
	return updated_news_if_breaking_news_enabled( $control ) && ( 'post' === $content_type );
}
function updated_news_breaking_news_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_breaking_news_content_type' )->value();
	return updated_news_if_breaking_news_enabled( $control ) && ( 'category' === $content_type );
}

/*========================Partial Refresh==============================*/
if ( ! function_exists( 'updated_news_breaking_news_title_text_partial' ) ) :
	// Title.
	function updated_news_breaking_news_title_text_partial() {
		return esc_html( get_theme_mod( 'updated_news_breaking_news_title' ) );
	}
endif;
