<?php
/**
 * Adore Themes Customizer
 *
 * @package Updated News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'updated_news_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'updated-news' ),
		'panel' => 'updated_news_frontpage_panel',
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'updated_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'updated_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Updated_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'updated_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'updated-news' ),
			'type'     => 'checkbox',
			'settings' => 'updated_news_banner_section_enable',
			'section'  => 'updated_news_banner_section',
			'priority' => 10,
		)
	)
);

// Featured Posts Sub Heading.
$wp_customize->add_setting(
	'updated_news_featured_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Updated_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'updated_news_featured_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Featured Posts Section', 'updated-news' ),
			'settings'        => 'updated_news_featured_posts_sub_heading',
			'section'         => 'updated_news_banner_section',
			'active_callback' => 'updated_news_if_banner_enabled',
			'priority' => 20,
		)
	)
);

// Featured Posts title settings.
$wp_customize->add_setting(
	'updated_news_banner_featured_posts_title',
	array(
		'default'           => __( 'Featured Posts', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_banner_featured_posts_title',
	array(
		'label'           => esc_html__( 'Title', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 30,
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'updated_news_banner_featured_posts_title',
		array(
			'selector'            => '.main-banner-section-wrapper .featured-posts h3.widget-title',
			'settings'            => 'updated_news_banner_featured_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// banner featured posts content type settings.
$wp_customize->add_setting(
	'updated_news_featured_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_featured_posts_content_type',
	array(
		'label'           => esc_html__( 'Featured Posts Content type:', 'updated-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'settings'        => 'updated_news_featured_posts_content_type',
		'type'            => 'select',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 40,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'updated-news' ),
			'category' => esc_html__( 'Category', 'updated-news' ),
		),
	)
);

for ( $i = 1; $i <= 8; $i++ ) {
	// Featured Posts post setting.
	$wp_customize->add_setting(
		'updated_news_featured_posts_post_' . $i,
		array(
			'sanitize_callback' => 'updated_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'updated_news_featured_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'updated-news' ), $i ),
			'section'         => 'updated_news_banner_section',
			'type'            => 'select',
			'choices'         => updated_news_get_post_choices(),
			'active_callback' => 'updated_news_featured_posts_section_content_type_post_enabled',
			'priority' => 50,
		)
	);

}

// Featured Posts category setting.
$wp_customize->add_setting(
	'updated_news_featured_posts_category',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_featured_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'type'            => 'select',
		'choices'         => updated_news_get_post_cat_choices(),
		'active_callback' => 'updated_news_featured_posts_section_content_type_category_enabled',
		'priority' => 60,
	)
);

// Banner Section Sub Heading.
$wp_customize->add_setting(
	'updated_news_banner_slider_section_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Updated_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'updated_news_banner_slider_section_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Slider Section', 'updated-news' ),
			'settings'        => 'updated_news_banner_slider_section_sub_heading',
			'section'         => 'updated_news_banner_section',
			'active_callback' => 'updated_news_if_banner_enabled',
			'priority' => 70,
		)
	)
);

// Banner title settings.
$wp_customize->add_setting(
	'updated_news_banner_slider_title',
	array(
		'default'           => __( 'Main News', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_banner_slider_title',
	array(
		'label'           => esc_html__( 'Title', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 80,
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'updated_news_banner_slider_title',
		array(
			'selector'            => '.main-banner-section-wrapper .banner-slider-outer h3.widget-title',
			'settings'            => 'updated_news_banner_slider_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// banner slider content type settings.
$wp_customize->add_setting(
	'updated_news_banner_slider_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_banner_slider_content_type',
	array(
		'label'           => esc_html__( 'Banner Slider Content type:', 'updated-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'type'            => 'select',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 90,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'updated-news' ),
			'category' => esc_html__( 'Category', 'updated-news' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// banner post setting.
	$wp_customize->add_setting(
		'updated_news_banner_slider_post_' . $i,
		array(
			'sanitize_callback' => 'updated_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'updated_news_banner_slider_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'updated-news' ), $i ),
			'section'         => 'updated_news_banner_section',
			'type'            => 'select',
			'choices'         => updated_news_get_post_choices(),
			'active_callback' => 'updated_news_banner_section_content_type_post_enabled',
			'priority' => 100,
		)
	);

}

// banner category setting.
$wp_customize->add_setting(
	'updated_news_banner_slider_category',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_banner_slider_category',
	array(
		'label'           => esc_html__( 'Category', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'type'            => 'select',
		'choices'         => updated_news_get_post_cat_choices(),
		'active_callback' => 'updated_news_banner_section_content_type_category_enabled',
		'priority' => 110,
	)
);

// Grid Posts Sub Heading.
$wp_customize->add_setting(
	'updated_news_grid_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Updated_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'updated_news_grid_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Grid Posts Section', 'updated-news' ),
			'settings'        => 'updated_news_grid_posts_sub_heading',
			'section'         => 'updated_news_banner_section',
			'active_callback' => 'updated_news_if_banner_enabled',
			'priority' => 120,
		)
	)
);

// Grid Posts title settings.
$wp_customize->add_setting(
	'updated_news_banner_grid_posts_title',
	array(
		'default'           => __( 'Grid Posts', 'updated-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'updated_news_banner_grid_posts_title',
	array(
		'label'           => esc_html__( 'Title', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 130,
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'updated_news_banner_grid_posts_title',
		array(
			'selector'            => '.main-banner-section-wrapper .banner-grid-outer h3.widget-title',
			'settings'            => 'updated_news_banner_grid_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Grid content type settings.
$wp_customize->add_setting(
	'updated_news_grid_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_grid_posts_content_type',
	array(
		'label'           => esc_html__( 'Grid Posts Content type:', 'updated-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'settings'        => 'updated_news_grid_posts_content_type',
		'type'            => 'select',
		'active_callback' => 'updated_news_if_banner_enabled',
		'priority' => 140,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'updated-news' ),
			'category' => esc_html__( 'Category', 'updated-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Grid Posts post setting.
	$wp_customize->add_setting(
		'updated_news_grid_posts_post_' . $i,
		array(
			'sanitize_callback' => 'updated_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'updated_news_grid_posts_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'updated-news' ), $i ),
			'section'         => 'updated_news_banner_section',
			'type'            => 'select',
			'choices'         => updated_news_get_post_choices(),
			'active_callback' => 'updated_news_grid_posts_section_content_type_post_enabled',
			'priority' => 150,
		)
	);

}

// Featured Posts category setting.
$wp_customize->add_setting(
	'updated_news_grid_posts_category',
	array(
		'sanitize_callback' => 'updated_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'updated_news_grid_posts_category',
	array(
		'label'           => esc_html__( 'Category', 'updated-news' ),
		'section'         => 'updated_news_banner_section',
		'type'            => 'select',
		'choices'         => updated_news_get_post_cat_choices(),
		'active_callback' => 'updated_news_grid_posts_section_content_type_category_enabled',
		'priority' => 160,
	)
);

/*========================Active Callback==============================*/
function updated_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'updated_news_banner_section_enable' )->value();
}

// banner slider
function updated_news_banner_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_banner_slider_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function updated_news_banner_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_banner_slider_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}

// banner featured posts
function updated_news_featured_posts_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_featured_posts_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function updated_news_featured_posts_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_featured_posts_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}

// banner grid posts
function updated_news_grid_posts_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_grid_posts_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function updated_news_grid_posts_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'updated_news_grid_posts_content_type' )->value();
	return updated_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}
