<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Updated News
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary-content"><?php esc_html_e( 'Skip to content', 'updated-news' ); ?></a>

		<div id="loader">
			<div class="loader-container">
				<div id="preloader">
					<div class="pre-loader-5"></div>
				</div>
			</div>
		</div><!-- #loader -->

		<header id="masthead" class="site-header">
			<div class="site-header-wrapper">
				<div class="adore-upper-header <?php echo esc_attr( ! empty( get_header_image() ) ? 'adore-header-image' : '' ); ?>" style="background-image: url('<?php echo esc_url( get_header_image() ); ?>')">

					<?php
					$header_class = has_nav_menu( 'social' ) ? 'has-search-form-and-social-menu' : 'has-search-form';
					?>
					<div class="theme-wrapper">
						<div class="adore-upper-header-wrap <?php echo esc_attr( $header_class ); ?>">

							<div class="site-branding">
								<?php

								if ( has_custom_logo() ) {
									?>
									<div class="site-logo">
										<?php the_custom_logo(); ?>
									</div>
									<?php
								}

								if ( get_theme_mod( 'updated_news_header_text_display', true ) === true ) {
									?>

									<div class="site-identity">
										<?php
										if ( is_front_page() && is_home() ) :
											?>
										<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
										<?php
									else :
										?>
										<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
										<?php
									endif;

									$updated_news_description = get_bloginfo( 'description', 'display' );
									if ( $updated_news_description || is_customize_preview() ) :
										?>
										<p class="site-description"><?php echo $updated_news_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
										<?php
									endif;
									?>
								</div>

								<?php
							}
							?>
						</div><!-- .site-branding -->

						<div class="header-search">
							<?php get_search_form(); ?>
						</div>

						<?php if ( has_nav_menu( 'social' ) ) { ?>
							<div class="social-icons">
								<?php
								wp_nav_menu(
									array(
										'menu_class'     => 'menu social-links',
										'link_before'    => '<span class="screen-reader-text">',
										'link_after'     => '</span>',
										'theme_location' => 'social',
									)
								);
								?>
							</div>
						<?php } ?>

					</div>
				</div>
			</div>
			<div class="header-outer-wrapper">
				<div class="adore-header">
					<div class="theme-wrapper">
						<div class="header-wrapper">

							<div class="header-nav-search">
								<div class="header-navigation">
									<nav id="site-navigation" class="main-navigation">
										<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
											<span></span>
											<span></span>
											<span></span>
										</button>
										<?php

										if ( has_nav_menu( 'primary' ) ) {

											wp_nav_menu(
												array(
													'theme_location' => 'primary',
													'menu_id' => 'primary-menu',
												)
											);

										}

										?>
									</nav><!-- #site-navigation -->
								</div>

								<div class="header-end">
									<div class="display-random-post">
										<?php
										$args         = array(
											'posts_per_page' => 1,
											'post_type' => 'post',
											'ignore_sticky_posts' => true,
											'orderby' => 'rand',
										);
										$random_query = new WP_Query( $args );
										if ( $random_query->have_posts() ) {
											while ( $random_query->have_posts() ) :
												$random_query->the_post();
												?>
												<a href="<?php the_permalink(); ?>" title="<?php esc_attr_e( 'View Random Post', 'updated-news' ); ?>">
													<i class="fas fa-random"></i>
												</a>
												<?php
											endwhile;
											wp_reset_postdata();
										}
										?>
									</div>
									<?php
									$button_label = get_theme_mod( 'updated_news_header_button_label', __( 'Subscription', 'updated-news' ) );
									$button_url   = get_theme_mod( 'updated_news_header_button_url', '' );
									$button_icon  = get_theme_mod( 'updated_news_counter_fontawesome_icon', 'fa-solid fa-bell' );
									if ( ! empty( $button_label ) ) {
										?>
										<div class="adore-custom-btn">
											<a href="<?php echo esc_url( $button_url ); ?>">
												<i class="<?php echo esc_attr( $button_icon ); ?>"></i>
												<span><?php echo esc_html( $button_label ); ?></span>
											</a>
										</div>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header><!-- #masthead -->

	<div id="primary-content" class="primary-content">

		<?php
		if ( ! is_front_page() || is_home() ) {

			if ( is_front_page() ) {

				$sorted_sections = array( 'breaking-news', 'banner', 'main-widgets-area' );

				foreach ( $sorted_sections as $sorted_section ) {
					require get_template_directory() . '/inc/frontpage-sections/' . $sorted_section . '.php';
				}
			}

			?>

			<div id="content" class="site-content theme-wrapper">
				<div class="theme-wrap">

				<?php } ?>
