<?php
/**
 * Widget Category Post
 *
 * @package Ultimate_Mag
 */
 
// register Ultimate_Mag_Category_Post widget
function ultimate_mag_register_category_post_widget() {
    register_widget( 'Ultimate_Mag_Category_Post' );
}
add_action( 'widgets_init', 'ultimate_mag_register_category_post_widget' );
 
 /**
 * Adds Ultimate_Mag_Category_Post widget.
 */
class Ultimate_Mag_Category_Post extends WP_Widget {

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			'ultimate_mag_Category_post', // Base ID
			esc_html__( 'PROSYS: Category Post', 'ultimate-mag' ), // Name
			array( 'description' => esc_html__( 'A Category Post Widget', 'ultimate-mag' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */




	public function widget( $args, $instance ) {
	   
        $title          = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $num_post       = ! empty( $instance['num_post'] ) ? $instance['num_post'] : 3 ;
        $show_thumb     = ! empty( $instance['show_thumbnail'] ) ? $instance['show_thumbnail'] : '';
        $show_date      = ! empty( $instance['show_postdate'] ) ? $instance['show_postdate'] : '';
        $category       = ! empty( $instance['cat'] ) ? $instance['cat'] : '';
        $category_type  = ! empty( $instance['category_type'] ) ? $instance['category_type'] : 'layout-one';

        $post_args = array(
            'post_type'           => 'post',
            'post_status'         => 'publish',
            'posts_per_page'      => $num_post,
            'ignore_sticky_posts' => true,
        );   

        if( $category ) $post_args['cat'] = $category;
        
        $qry = new WP_Query( $post_args );
        
        if( $qry->have_posts() ){
            echo $args['before_widget'];
            if( isset($title) && $title != "" ) { echo $args['before_title'] . apply_filters( 'widget_title', $title, $instance, $this->id_base ) . $args['after_title']; }
            switch ( $category_type ){
            case 'layout-two': ?>
            <div class="row">
                <div class="inner-col">
                    <div class="inner-row">
                        <div class="category-list <?php if( isset($category_type )) echo $category_type; ?>">
                            <?php 
                            while( $qry->have_posts() ){
                                $qry->the_post();
                            ?>
                                <div class="pst-col-6">
                                    <div class="item-holder">
                                        <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                            <div class="post-thumbnail-holder">
                                                <a href="<?php the_permalink();?>" class="post-thumbnail">
                                                    <?php the_post_thumbnail( 'ultimate-mag-four-col' );?>
                                                </a>
                                                <div class="colored-category">
                                                    <?php ultimate_mag_colored_category(); ?>
                                                </div>
                                            </div>
                                        <?php }?>
                                        <div class="entry-header">
                                            <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                            <?php if( $show_date  ){?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                                        </a>                                    
                                                    </span>
                                                </div>
                                            <?php }?>
                                        </div>    
                                        <div class="entry-content">
                                            <?php the_excerpt(); ?>
                                        </div> 
                                    </div>         
                                </div>        
                            <?php    
                            }
                        ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            break;
            case 'layout-three': ?>
            <div class="row">
                <div class="inner-col">
                    <div class="inner-row">
                        <div class="category-list <?php if( isset($category_type )) echo $category_type; ?>">
                            <?php 
                            $counter = 0;
                            while( $qry->have_posts() ){
                                $qry->the_post();
                           
                                if( $counter == 0 ){
                            ?>  

                                <div class="pst-col-12 featured-post">
                                    <div class="item-holder">
                                        <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                            <div class="post-thumbnail-holder">
                                                <a href="<?php the_permalink();?>" class="post-thumbnail">
                                                    <?php the_post_thumbnail( 'ultimate-mag-three-col' );?>
                                                </a>
                                                <div class="colored-category">
                                                    <?php ultimate_mag_colored_category(); ?>
                                                </div>
                                            </div>
                                        <?php }?>
                                        <div class="entry-header">
                                            <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                            <?php if( $show_date  ){?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                                        </a>                                    
                                                    </span>
                                                </div>
                                            <?php }?>
                                        </div>    
                                        <div class="entry-content">
                                            <?php the_excerpt(); ?>
                                        </div> 
                                    </div>         
                                </div>  

                            <?php } else { ?>
                                <div class="pst-col-4">
                                    <div class="item-holder">
                                        <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                            <div class="post-thumbnail-holder">
                                                <a href="<?php the_permalink();?>" class="post-thumbnail">
                                                    <?php the_post_thumbnail( 'ultimate-mag-three-col' );?>
                                                </a>
                                            </div>
                                        <?php }?>
                                        <div class="entry-header">
                                            <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                            <?php if( $show_date  ){?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                                        </a>                                    
                                                    </span>
                                                </div>
                                            <?php }?>
                                        </div>  
                                    </div>         
                                </div> 
                            <?php    
                            }
                            $counter++;
                            }   
                        ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php 
            break;
            case 'layout-four': ?>
            <div class="row">
                <div class="inner-col">
                    <div class="inner-row">
                        <div class="category-list <?php if( isset($category_type )) echo $category_type; ?>">
                            <?php 
                            $counter = 0;
                            while( $qry->have_posts() ){
                                $qry->the_post();
                           
                                if( $counter == 0 ){
                            ?>  

                                <div class="pst-col-6 featured-post">
                                    <div class="item-holder">
                                        <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                            <div class="post-thumbnail-holder">
                                                <a href="<?php the_permalink();?>" class="post-thumbnail">
                                                    <?php the_post_thumbnail( 'ultimate-mag-three-col' );?>
                                                </a>
                                                <div class="colored-category">
                                                    <?php ultimate_mag_colored_category(); ?>
                                                </div>
                                            </div>
                                        <?php }?>
                                        <div class="entry-header">
                                            <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                            <?php if( $show_date  ){?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                                        </a>                                    
                                                    </span>
                                                </div>
                                            <?php }?>
                                        </div>    
                                        <div class="entry-content">
                                            <?php the_excerpt(); ?>
                                        </div> 
                                    </div>         
                                </div>  

                            <?php } else { ?>
                                <div class="pst-col-6 unfeatured-post">
                                    <div class="item-holder">
                                        <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                            <div class="post-thumbnail-holder">
                                                <a href="<?php the_permalink();?>" class="post-thumbnail">
                                                    <?php the_post_thumbnail( 'thumbnail' );?>
                                                </a>
                                               <!-- <div class="colored-category">
                                                    <?php //ultimate_mag_colored_category(); ?>
                                                </div>-->
                                            </div>
                                        <?php }?>
                                        <div class="entry-header">
                                            <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                            <?php if( $show_date  ){?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <a href="<?php the_permalink(); ?>">
                                                            <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                                        </a>                                    
                                                    </span>
                                                </div>
                                            <?php }?>
                                        </div>  
                                    </div>         
                                </div> 
                            <?php    
                            }
                            $counter++;
                            }   
                        ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php 
            break;

            case 'layout-one':
            default: ?>
            <ul class="category-list <?php if( isset($category_type )) echo $category_type; ?>">
                <?php 
                while( $qry->have_posts() ){
                    $qry->the_post();
                ?>
                    <li>
                        <div class="item-holder">
                            <?php if( has_post_thumbnail() && $show_thumb ){ ?>
                                <div class="post-thumbnail-holder">
                                    <a href="<?php the_permalink();?>" class="post-thumbnail">
                                        <?php the_post_thumbnail( 'ultimate-mag-three-col' );?>
                                    </a>
                                </div>
                            <?php }?>
                            <div class="entry-header">
                                <h3 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>
                                <?php if( $show_date  ){?>
                                    <div class="entry-meta">
                                        <span class="posted-on">
                                            <a href="<?php the_permalink(); ?>">
                                                <time><?php  echo esc_html( get_the_date( get_option( 'date_format' ) ) ); ?></time>
                                            </a>                                    
                                        </span>
                                    </div>
                                <?php }?>
                            </div>    
                            <div class="entry-content">
                                <?php the_excerpt(); ?>
                                <div class="entry-footer">
                                <?php ultimate_mag_colored_category(); ?>
                                </div>
                            </div>  
                        </div>            
                    </li>        
                <?php    
                }
            ?>
            </ul>
            <?php
            }
            echo $args['after_widget'];   
        }
        wp_reset_postdata();  
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
        
        $title          = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $num_post       = ! empty( $instance['num_post'] ) ? $instance['num_post'] : 3 ;
        $show_thumbnail = ! empty( $instance['show_thumbnail'] ) ? $instance['show_thumbnail'] : '';
        $show_postdate  = ! empty( $instance['show_postdate'] ) ? $instance['show_postdate'] : '';
        $category       = ! empty( $instance['cat'] ) ? $instance['cat'] : '';
        $category_type  = ! empty( $instance['category_type'] ) ? $instance['category_type'] : 'layout-one';
        
        ?>
		
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'ultimate-mag' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) );  ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>

        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'cat' ) ); ?>"><?php esc_html_e( 'Category:', 'ultimate-mag' ); ?></label> 
            <?php wp_dropdown_categories( Array(
                        'orderby'            => 'ID', 
                        'order'              => 'ASC',
                        'show_count'         => 1,
                        'hide_empty'         => 1,
                        'hide_if_empty'      => true,
                        'echo'               => 1,
                        'selected'           => $category,
                        'hierarchical'       => 1, 
                        'name'               => $this->get_field_name( 'cat' ),
                        'id'                 => $this->get_field_id( 'cat' ),
                        'taxonomy'           => 'category',
                    ) ); ?>
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'num_post' ) ); ?>"><?php esc_html_e( 'Number of Posts', 'ultimate-mag' ); ?></label> 
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'num_post' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'num_post' ) ); ?>" type="number" step="1" min="1" value="<?php echo esc_attr( $num_post ); ?>" />
		</p>
        
        <p>
            <input id="<?php echo esc_attr( $this->get_field_id( 'show_thumbnail' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_thumbnail' ) ); ?>" type="checkbox" value="1" <?php checked( '1', $show_thumbnail ); ?>/>
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_thumbnail' ) ); ?>"><?php esc_html_e( 'Show Post Thumbnail', 'ultimate-mag' ); ?></label>
		</p>
        
        <p>
            <input id="<?php echo esc_attr( $this->get_field_id( 'show_postdate' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_postdate' ) ); ?>" type="checkbox" value="1" <?php checked( '1', $show_postdate ); ?>/>
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_postdate' ) ); ?>"><?php esc_html_e( 'Show Post Date', 'ultimate-mag' ); ?></label>
		</p>

        <p> 
            <label for="<?php echo esc_attr( $this->get_field_id( 'category_type' ) ); ?>"><?php esc_html_e( 'Category Layout', 'ultimate-mag' ); ?></label>
            <select id="<?php echo esc_attr( $this->get_field_name( 'category_type' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'category_type' ) ); ?>">
              <option value="<?php echo esc_attr( 'layout-one' ); ?>" <?php selected( 'layout-one', $category_type ); ?> ><?php esc_html_e( 'Layout One', 'ultimate-mag'); ?></option>
              <option value="<?php echo esc_attr( 'layout-two' ); ?>" <?php selected( 'layout-two', $category_type ); ?> ><?php esc_html_e( 'Layout Two', 'ultimate-mag'); ?></option>
              <option value="<?php echo esc_attr( 'layout-three' ); ?>" <?php selected( 'layout-three', $category_type ); ?> ><?php esc_html_e( 'Layout Three', 'ultimate-mag'); ?></option>
              <option value="<?php echo esc_attr( 'layout-four' ); ?>" <?php selected( 'layout-four', $category_type ); ?> ><?php esc_html_e(' Layout Four', 'ultimate-mag'); ?></option>
            </select>
        </p>

		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		
        $instance = array();
		
        $instance['title']          = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['num_post']       = ! empty( $new_instance['num_post'] ) ? absint( $new_instance['num_post'] ) : 3 ;        
        $instance['show_thumbnail'] = ! empty( $new_instance['show_thumbnail'] ) ? absint( $new_instance['show_thumbnail'] ) : '';
        $instance['show_postdate']  = ! empty( $new_instance['show_postdate'] ) ? absint( $new_instance['show_postdate'] ) : '';
        $instance['cat']  = ! empty( $new_instance['cat'] ) ? sanitize_text_field( $new_instance['cat'] ) : '';
        $instance['category_type']  = ! empty( $new_instance['category_type'] ) ? sanitize_text_field( $new_instance['category_type'] ) : '';
		
        return $instance;
                
	}

} // class Ultimate_Mag_Category_Post 