<?php
/**
 * Template Hooks
 *
 * @package ultimate_mag
 */

/**
 * Doctype
 * 
 * @see ultimate_mag_doctype_cb 
 */
add_action( 'ultimate_mag_doctype','ultimate_mag_doctype_cb' );

/**
 * Before wp_head
 * 
 * @see ultimate_mag_head
*/
add_action( 'ultimate_mag_before_wp_head', 'ultimate_mag_head' );

/**
 * Before Header
 * 
 * @see ultimate_mag_page_start - 20
*/
add_action( 'ultimate_mag_before_header', 'ultimate_mag_page_start', 20 );

/**
 * ultimate_mag Header
 * 
 * @see ultimate_mag_header_start  - 20 
 * @see ultimate_mag_header_top    - 40 
 * @see ultimate_mag_header_bottom - 50 
 * @see ultimate_mag_header_end 	  - 60 
*/

add_action( 'ultimate_mag_header', 'ultimate_mag_header_start', 20 );
add_action( 'ultimate_mag_header', 'ultimate_mag_header_top', 40 );
add_action( 'ultimate_mag_header', 'ultimate_mag_header_bottom', 50 );
add_action( 'ultimate_mag_header', 'ultimate_mag_header_end', 60 );
add_action( 'ultimate_mag_header', 'ultimate_mag_breaking_news_cb', 70);

/**
 * Home Page Contents
 * 
 * @see ultimate_mag_featured    - 20
 * @see ultimate_mag_about     - 30
*/
add_action( 'ultimate_mag_home_page_featured', 'ultimate_mag_featured', 10 );
add_action( 'ultimate_mag_home_page_featured', 'ultimate_mag_special', 20 );

/**
 * Home Page Contents
 * 
 * @see ultimate_mag_about     - 30
*/
add_action( 'ultimate_mag_home_page', 'ultimate_mag_about', 30 );

/**
 * ultimate_mag Content
 * 
 * @see ultimate_mag_content_start
*/
add_action( 'ultimate_mag_before_content', 'ultimate_mag_content_start' );

/**
 * Before Page entry content
 * 
 * @see ultimate_mag_page_content_image
*/
add_action( 'ultimate_mag_before_page_entry_content', 'ultimate_mag_page_content_image' );

/**
 * Before Post entry content
 * 
 * @see ultimate_mag_post_content_image - 10
 * @see ultimate_mag_post_entry_header  - 20
*/
add_action( 'ultimate_mag_before_post_entry_content', 'ultimate_mag_post_content_image', 10 );
add_action( 'ultimate_mag_before_post_entry_content', 'ultimate_mag_post_entry_header', 20 );

/**
 * After post content
 * 
 * @see ultimate_mag_post_author  - 20
*/
add_action( 'ultimate_mag_after_post_content', 'ultimate_mag_post_author', 20 );

/**
 * Comment
 * 
 * @see ultimate_mag_get_comment_section 
*/
add_action( 'ultimate_mag_comment', 'ultimate_mag_get_comment_section' );

/**
 * After Content
 * 
 * @see ultimate_mag_content_end - 20
*/
add_action( 'ultimate_mag_after_content', 'ultimate_mag_content_end', 20 );

/**
 * Numinous Footer
 * 
 * @see ultimate_mag_footer_start  - 20
 * @see ultimate_mag_footer_widgets    - 30
 * @see ultimate_mag_footer_credit - 40
 * @see ultimate_mag_footer_end    - 50
*/
add_action( 'ultimate_mag_footer', 'ultimate_mag_footer_start', 20 );
add_action( 'ultimate_mag_footer', 'ultimate_mag_footer_widgets', 30 );
add_action( 'ultimate_mag_footer', 'ultimate_mag_footer_credit', 40 );
add_action( 'ultimate_mag_footer', 'ultimate_mag_footer_end', 50 );

/**
 * After Footer
 * 
 * @see ultimate_mag_page_end - 20
*/
add_action( 'ultimate_mag_after_footer', 'ultimate_mag_back_to_top', 15 );
add_action( 'ultimate_mag_after_footer', 'ultimate_mag_page_end', 20 );