<?php
/**
 * Custom template function for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package ultimate_mag
 */

if( ! function_exists( 'ultimate_mag_doctype_cb' ) ) :
/**
 * Doctype Declaration
 * 
 * @since 1.0.1
*/
function ultimate_mag_doctype_cb(){
    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <?php
}
endif;


if( ! function_exists( 'ultimate_mag_head' ) ) :
/**
 * Before wp_head
 * 
 * @since 1.0.1
*/
function ultimate_mag_head(){
    ?>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php
}
endif;

if( ! function_exists( 'ultimate_mag_social_links' ) ) :
/**
 * Before wp_head
 * 
 * @since 1.0.1
*/
function ultimate_mag_social_links(){
    $ultimate_mag_twitter    = get_theme_mod( 'ultimate_mag_twitter' );
    $ultimate_mag_facebook   = get_theme_mod( 'ultimate_mag_facebook' );
    $ultimate_mag_youtube    = get_theme_mod( 'ultimate_mag_youtube' );
    $ultimate_mag_googleplus = get_theme_mod( 'ultimate_mag_googleplus' );
    $ultimate_mag_linkedin   = get_theme_mod( 'ultimate_mag_linkedin' );
    $ultimate_mag_pinterest  = get_theme_mod( 'ultimate_mag_pinterest' );

    ?>

    <ul class="social-links">
        <?php if($ultimate_mag_facebook){ ?> <li><a href="<?php echo esc_url($ultimate_mag_facebook); ?>"><i class="fab fa-facebook-f"></i></a></li><?php } ?>
        <?php if($ultimate_mag_youtube){ ?> <li><a href="<?php echo esc_url($ultimate_mag_youtube); ?>"><i class="fab fa-youtube"></i></a></li><?php } ?>        
        <?php if($ultimate_mag_linkedin){ ?> <li><a href="<?php echo esc_url($ultimate_mag_linkedin); ?>"><i class="fab fa-linkedin-in"></i></a></li><?php } ?>  
        <?php if($ultimate_mag_pinterest){ ?> <li><a href="<?php echo esc_url($ultimate_mag_pinterest); ?>"><i class="fab fa-pinterest-p"></i></a></li><?php } ?>      
        <?php if($ultimate_mag_twitter){ ?> <li><a href="<?php echo esc_url($ultimate_mag_twitter); ?>"><i class="fab fa-twitter"></i></a></li><?php } ?>
        <?php if($ultimate_mag_googleplus){ ?> <li><a href="<?php echo esc_url($ultimate_mag_googleplus); ?>"><i class="fab fa-google-plus-g"></i></a></li><?php } ?>
    </ul>
    <?php
}
endif;



if( ! function_exists( 'ultimate_mag_header_start' ) ) :
/**
 * Header Start
 * 
 * @since 1.0.1
*/
function ultimate_mag_header_start(){
    ?>
    <header id="masthead" class="site-header header-one" role="banner">
    <?php 
}
endif;

if( ! function_exists( 'ultimate_mag_header_top' ) ) :
/**
 * Header Site Branding
 * 
 * @since 1.0.1
*/
function ultimate_mag_header_top(){
$phone = get_theme_mod( 'ultimate_mag_phone' );
$email = get_theme_mod( 'ultimate_mag_email' );
$ultimate_mag_ed_date = get_theme_mod('ultimate_mag_ed_date', '1'); 
$ultimate_mag_date_format = get_theme_mod('ultimate_mag_date_format', 'default'); 
 ?>
    <div class="header-top">
        <div class="container"> 
            <div class="row">   
                <?php 
                    if( $ultimate_mag_date_format == 'default' ){
                        $date_format = 'l, jS F Y';
                    } else {
                        $date_format = get_option('date_format');
                    }
                ?>

                <div class="col-4">
                    <div class="header-date">
                        <?php echo date_i18n(  esc_attr( $date_format ) ); ?>
                    </div>
                </div>
                <div class="col-8">
                    <div class="header-contact-info">
                         
                        <?php
                            if( $phone ){ 
                                echo '<div class="contact-phone">';
                                    echo '<a href="tel:' . preg_replace('/\D/', '', $phone) . '" class="tel-link">';
                                    echo '<i class="fas fa-phone-alt"></i>';
                                    echo '<span>'.esc_attr( $phone ).'</span>'; 
                                    echo '</a>';
                                echo '</div>';
                            }

                            if( $email ){ 
                                echo '<div class="contact-email">';
                                    echo '<a href="mailto:' .  esc_attr( $email ) . '" class="email-link">';
                                    echo '<i class="fas fa-envelope"></i>';
                                    echo '<span>'.esc_attr( $email).'</span>'; 
                                    echo '</a>';
                                echo '</div>';
                            } 
                        ?>
                        
                    </div>
                    <?php ultimate_mag_social_links(); ?>
                </div> 
            </div>
        </div>
    </div> 
        
    <div class="header-middle">
        <div class="container">
            <div class="site-branding">
                <?php 
                    if( function_exists( 'has_custom_logo' ) && has_custom_logo() ){
                              the_custom_logo();
                          } 
                ?>
                <div class="text-logo">
                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                  <?php
                        $description = get_bloginfo( 'description', 'display' );
                        if ( ! empty( esc_html( $description ) ) || is_customize_preview() ) { ?>
                          <p class="site-description"><?php echo esc_html( $description ); /* WPCS: xss ok. */ ?></p>
                  <?php } ?>
                </div>  
            </div><!-- .site-branding -->

            <?php
                /** Header Advertisement */
                do_action( 'ultimate_mag_header_ad' );
            ?>
        </div>
    </div>
    <?php 
}
endif;

if( ! function_exists( 'ultimate_mag_header_bottom' ) ) :
/**
 * Header Site Branding
 * 
 * @since 1.0.1
*/
function ultimate_mag_header_bottom(){
    $searchform = get_theme_mod( 'ultimate_mag_ed_search_form' );
    ?>
    <div class="header-bottom">  
        <div class="container">
            <?php 
            echo '<div class="home-button"><a href="' . esc_url( home_url( '/' ) ) . '"><i class="fa fa-home"></i></a></div>';
            ?>
             <?php if( !empty( $searchform ) ){ ?>
                <div class="search-content">
                    <a class="btn-search" id="myBtn" href="#"><span class="fa fa-search"></span></a>
                    <div id="formModal" class="modal">
                        <div class="modal-content">
                            <?php get_search_form(); ?>
                        </div>
                    </div>
                </div>
                <?php } ?>
            <nav id="site-navigation" class="main-navigation">               
                <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_id' => 'primary-menu' ) ); ?>
            </nav><!-- #site-navigation -->
             
            <div class="mobile-header-containter">
                <div class="responsive-slick-menu"></div>     
            </div>
        </div>
    </div>
    <?php 
}
endif;

if( ! function_exists( 'ultimate_mag_header_end' ) ) :
/**
 * Header End
 * 
 * @since 1.0.1
*/
function ultimate_mag_header_end(){
    ?>
    </header><!-- #masthead -->
    <?php 
}
endif;

if( ! function_exists( 'ultimate_mag_ad' ) ) :
/**
 * Header AD
*/
function ultimate_mag_ad(){
    $ed_header_ad = get_theme_mod( 'ultimate_mag_ed_header_ad' ); //from customizer
    $ad_img       = get_theme_mod( 'ultimate_mag_header_ad' ); //from customizer
    $ad_link      = get_theme_mod( 'ultimate_mag_header_ad_link' ); //from customizer
    $ad_image     = wp_get_attachment_image_src( $ad_img, 'full' );
    $target       = get_theme_mod( 'ultimate_mag_open_link_diff_tab', '1' ) ? 'target="_blank"' : '';
    
    if( $ed_header_ad && $ad_img ){ ?>
    <div class="advertise">
        <?php if( $ad_link ) echo '<a href="' . esc_url( $ad_link ) . '" ' . $target . '>'; ?>
            <img src="<?php echo esc_url( $ad_image[0] ); ?>"  />
        <?php if( $ad_link ) echo '</a>'; ?>        
    </div>
    <?php
    }
}
endif;
add_action( 'ultimate_mag_header_ad', 'ultimate_mag_ad' );


if( ! function_exists( 'ultimate_mag_featured' ) ) :
/**
 * Home Page featured Section
 * 
 * @since 1.0.1
*/
function ultimate_mag_featured(){

    $slider_caption     = get_theme_mod( 'ultimate_mag_slider_caption', '1' );
    $slider_readmore    = get_theme_mod( 'ultimate_mag_slider_readmore', __( 'Learn More', 'ultimate-mag' ) );
    
    $featured_enable     = get_theme_mod( 'ultimate_mag_ed_featured_section' );
             
    if( $featured_enable ){ ?>

    <section class="featured-section">
        <div class="container">
            <div class="row">
                <div class="inner-col">
                    <div class="inner-row">
                        <div class="featured-lg-col">
                            <?php
                            echo '<div class="fadeout owl-carousel owl-theme clearfix">';
                            for( $i=1; $i<=3; $i++){  
                                $ultimate_mag_slider_post_id = get_theme_mod( 'ultimate_mag_slider_post_'.$i, '' ); 
                                if( $ultimate_mag_slider_post_id ){
                                    $qry = new WP_Query ( array( 'p' => absint( $ultimate_mag_slider_post_id ) ) );            
                                    if( $qry->have_posts() ){ 
                                        while( $qry->have_posts() ){
                                        $qry->the_post();
                                            ?>
                                            <div class="item-holder">
                                                <?php 
                                                if( has_post_thumbnail() ){ 
                                                    echo '<a href="'.esc_url(get_the_permalink() ).'" class="post-thumbnail">';
                                                    the_post_thumbnail( 'ultimate-mag-slider' );
                                                    echo '</a>';
                                                    
                                                }else{
                                                    echo '<a href="'.the_permalink().'" class="post-thumbnail"><img src="'. esc_url( get_template_directory_uri() ).'/images/banner.jpg"></a>';
                                                } 
                                                        if( $slider_caption ){ ?>
                                                        <div class="text-holder">
                                                            <?php ultimate_mag_colored_category(); ?>
                                                            <div class="banner-text-item">
                                                                <a href="<?php the_permalink(); ?>"><?php the_title('<h2 class="entry-title">','</h2>'); ?></a>
                                                                <?php ultimate_mag_posted_on() ?>
                                                            </div>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                        <?php 
                                        }
                                    }
                                }
                            }
                            wp_reset_postdata();  
                            echo '</div>';?>

                        </div>
                        <div class="featured-items">
                            <?php
                            for( $i = 1; $i <= 4; $i++ ){
                                 $ultimate_mag_featured_post_id = get_theme_mod( 'ultimate_mag_feature_post_'.$i, '' ); 
                                if( $ultimate_mag_featured_post_id ){
                                $qry = new WP_Query ( array( 'p' => absint( $ultimate_mag_featured_post_id ) ) );
                                    if( $qry->have_posts() ){
                                        while( $qry->have_posts() ){
                                            $qry->the_post();
                                        ?>
                                        <div class="small featured-sm-col">
                                            <div class="item-holder">
                                                <?php
                                                    if( has_post_thumbnail() ){ 
                                                        echo '<a href="' . esc_url( get_the_permalink() ) .'">';
                                                            the_post_thumbnail( 'ultimate-mag-four-col' ); 
                                                        echo '</a>';
                                                    }else{
                                                        
                                                        echo '<a href="' . esc_url( get_the_permalink() ) .'">';
                                                            echo '<img src="' . esc_url( get_template_directory_uri() ).'/images/team-profile-one.jpg" alt="'.esc_attr( the_title_attribute() ).'">';
                                                        echo '</a>';
                                                    }
                                                ?>
                                                <div class="text-holder">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title('<h3 class="entry-title">','</h3>'); ?></a>
                                                    <?php ultimate_mag_posted_on(); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                        }
                                    }
                                    wp_reset_postdata();  
                                }
                            } ?>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php

    }   

}

endif;


if( ! function_exists( 'ultimate_mag_special' ) ) :
/**
 * Home Page featured Section
 * 
 * @since 1.0.1
*/
function ultimate_mag_special(){

    $special_enable    = get_theme_mod( 'ultimate_mag_ed_special_section' );
    $section_title    = get_theme_mod( 'ultimate_mag_special_title' );
    $special_cat    = get_theme_mod( 'ultimate_mag_special_cat' );

    if( $special_enable ){ ?>

    <section class="special-section">
        <div class="container">

            <?php if( $section_title ) { echo '<h1 class="section-header">'. esc_html( $section_title ) . '</h1>' ; } ?>

            <div class="row">
                
                <div class="special-items">
                    <?php

                        $qry = new WP_Query ( array( 
                                'post_type' => 'post',
                                'cat'       => $special_cat,
                                )
                            );

                            if( $qry->have_posts() ){
                                while( $qry->have_posts() ){
                                    $qry->the_post();
                                ?>
                                <div class="small col-4">
                                    <div class="item-holder">
                                        <?php
                                            if( has_post_thumbnail() ){ 
                                                echo '<a href="' . esc_url( get_the_permalink() ) .'" class="post-thumbnail">';
                                                    the_post_thumbnail( 'ultimate-mag-six-col' ); 
                                                echo '</a>';
                                            }else{
                                                
                                                echo '<a href="' . esc_url( get_the_permalink() ) .'" class="post-thumbnail">';
                                                    echo '<img src="' . esc_url( get_template_directory_uri() ).'/images/team-profile-one.jpg" alt="'.esc_attr( the_title_attribute() ).'">';
                                                echo '</a>';
                                            }
                                        ?>
                                        <div class="text-holder">
                                            <a href="<?php the_permalink(); ?>"><?php the_title('<h3 class="entry-title">','</h3>'); ?></a>
                                            <?php ultimate_mag_posted_on(); 
                                                //the_excerpt(); ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                            }
                            wp_reset_postdata();  
                     ?>
                    
                </div>
            </div>
        </div>
    </section>
<?php

    }   

}

endif;


if( ! function_exists( 'ultimate_mag_about' ) ) :
/**
 * Home Page about Section
 * 
 * @since 1.0.1
*/
function ultimate_mag_about(){
    $sidebar_layout = ultimate_mag_sidebar_layout();
    $about_enable     = get_theme_mod( 'ultimate_mag_ed_about_section' );

    echo '<div id="content" class="site-content"><div class="container"><div class="row">'; ?>
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <?php
                    if( $about_enable ){
                        while ( have_posts() ) : the_post(); ?>

                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                                <?php do_action( 'ultimate_mag_before_page_entry_content' ); ?>
                                 <header class="entry-header">
                                    <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
                                </header><!-- .entry-header -->
                                <div class="entry-content">
                                    <?php
                                        the_content();
                                    ?>
                                </div><!-- .entry-content -->

                            </article><!-- #post-<?php the_ID(); ?> -->
                            <?php
                        endwhile; // End of the loop.
                    }

                    dynamic_sidebar( 'home-main-sidebar' );
                ?>
            </main><!-- #main -->
        </div><!-- #primary -->  
        <?php
        if( $sidebar_layout == 'right-sidebar' ) { get_sidebar(); }
            
    echo '</div></div></div>'; 
}

endif;

if( ! function_exists( 'ultimate_mag_breaking_news_cb' ) ) :
/**
 * Breaking News
*/
function ultimate_mag_breaking_news_cb(){
    
    $breaking_news_cat   = get_theme_mod( 'ultimate_mag_breaking_news_cat' ); //from customizer
    $breaking_news_label = get_theme_mod( 'ultimate_mag_breaking_news_label', __( 'Breaking News', 'ultimate-mag' ) ); //from customizer
    
    if( $breaking_news_label ){
        $label = $breaking_news_label;
    }else if( !empty ( $breaking_news_cat ) ){
        $cat   = get_category( $breaking_news_cat );
        $label = $cat->name;
    }
    
    
    if( $breaking_news_cat ){
        $args = array(
            'post_type'           => 'post', 
            'cat'                 => $breaking_news_cat,
            'post_status'         => 'publish',
            'posts_per_page'      => -1,
            'ignore_sticky_posts' => true 
        );
        $breaking_qry = new WP_Query( $args );
        
        if( $breaking_qry->have_posts() ){
        ?>
            <div class="scrolling-news">
                <div class="container">
                    <a href="<?php echo esc_url( get_category_link( $breaking_news_cat ) ); ?>" class="breaking-news-link"><?php echo esc_html( $label ); ?></a>
                    <ul id="news-ticker" class= "js-hidden">
                    <?php 
                        while( $breaking_qry->have_posts() ){
                            $breaking_qry->the_post();
                        ?>
                        <li><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></li>
                        <?php
                        }    
                    ?>
                    </ul>
                </div>
            </div>
        <?php
        }
        wp_reset_postdata();
    }
}
endif;


if( ! function_exists( 'ultimate_mag_content_start' ) ) :
/**
 * Content Start
 * 
 * @since 1.0.1
*/
function ultimate_mag_content_start(){ 
    $ed_featured = get_theme_mod( 'ultimate_mag_ed_featured_section' );
    $class = is_404() ? 'error-holder' : 'row' ;
    
    if( !( $ed_featured && is_front_page() && !is_home()) ){
    
    /** Breadcrumb */    
    do_action( 'ultimate_mag_breadcrumbs' );

    ?>
    <div id="content" class="site-content">
        <div class="container">
             <div class="<?php echo esc_attr( $class ); ?>">
    <?php
    }
}
endif;

if( ! function_exists( 'ultimate_mag_page_content_image' ) ) :
/**
 * Page Featured Image
 * 
 * @since 1.0.1
*/
function ultimate_mag_page_content_image(){
    $sidebar_layout = ultimate_mag_sidebar_layout();
    if( has_post_thumbnail() ){
        echo '<div class="post-thumbnail">';
            if( is_active_sidebar( 'right-sidebar' ) && ( $sidebar_layout == 'right-sidebar' ) ) {
                the_post_thumbnail( 'ultimate-mag-with-sidebar' );    
            }else{
                the_post_thumbnail( 'ultimate-mag-without-sidebar' );
            }
        echo '</div>';
    }
}
endif;


if( ! function_exists( 'ultimate_mag_post_content_image' ) ) :
/**
 * Post Featured Image
 * 
 * @since 1.0.1
*/
function ultimate_mag_post_content_image(){
    $archives_layout = get_theme_mod( 'ultimate_mag_archives_layout', 'vertical'); 

    if( ( $archives_layout == 'horizontal' ) && ( is_home() || is_archive() )){
        echo ( !is_single() ) ? '<a href="' . esc_url( get_the_permalink() ) . '" class="post-thumbnail">' : '<div class="post-thumbnail">'; 
         ( is_active_sidebar( 'right-sidebar' ) ) ? the_post_thumbnail( 'ultimate-mag-four-col' ) : the_post_thumbnail( 'ultimate-mag-four-col' ) ; 
        echo ( !is_single() ) ? '</a>' : '</div>' ;
    }else {
        if( has_post_thumbnail() ){
            echo ( !is_single() ) ? '<a href="' . esc_url( get_the_permalink() ) . '" class="post-thumbnail">' : '<div class="post-thumbnail">'; 
                 ( is_active_sidebar( 'right-sidebar' ) ) ? the_post_thumbnail( 'ultimate-mag-with-sidebar' ) : the_post_thumbnail( 'ultimate-mag-without-sidebar' ) ; 
            echo ( !is_single() ) ? '</a>' : '</div>' ;  
        } 
    }
}
endif;

if( ! function_exists( 'ultimate_mag_post_entry_header' ) ) :
/**
 * Post Entry Header
 * 
 * @since 1.0.1
*/
function ultimate_mag_post_entry_header(){
    $archives_layout = get_theme_mod( 'ultimate_mag_archives_layout', 'vertical'); 
    ?>
    
    <header class="entry-header">
        <?php
            if( $archives_layout == 'vertical') ultimate_mag_colored_category();
            if ( is_single() ) {
                the_title( '<h1 class="entry-title">', '</h1>' );
            } else {
                the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
            }

        if ( 'post' === get_post_type() ) : ?>
        <div class="entry-meta">
            <?php  
                ultimate_mag_posted_on();                
                ultimate_mag_comments();
            ?>
        </div><!-- .entry-meta -->
        <?php
        endif; ?>
    </header>

    <?php
}
endif;

if( ! function_exists( 'ultimate_mag_archive_entry_header_before' ) ) :
/**
 * Archive Entry Header
 * 
 * @since 1.0.1
*/
function ultimate_mag_archive_entry_header_before(){
    echo '<div class = "text-holder" >';
}    
endif;   
    
if( ! function_exists( 'ultimate_mag_archive_entry_header' ) ) :
/**
 * Archive Entry Header
 * 
 * @since 1.0.1
*/
function ultimate_mag_archive_entry_header(){
    ?>
    <header class="entry-header">
        <div class="entry-meta">
            <?php ultimate_mag_posted_on_date(); ?>
        </div><!-- .entry-meta -->
        <h2 class="entry-title"><a href="<?php the_permalink(); ?> "><?php the_title(); ?></a></h2>
    </header>   
    <?php
}
endif;

if( ! function_exists( 'ultimate_mag_post_author' ) ) :
/**
 * Post Author Bio
 * 
 * @since 1.0.1
*/
function ultimate_mag_post_author(){
    if( get_the_author_meta( 'description' ) ){
        global $post;
    ?>
    <section class="author-section">
        <div class="img-holder"><?php echo get_avatar( get_the_author_meta( 'ID' ), 100 ); ?></div>
            <div class="text-holder">
                <strong class="name"><?php the_author_meta( 'display_name', $post->post_author ); ?></strong>
                <?php the_author_meta( 'description' ); ?>
            </div>
    </section>
    <?php  
    }  
}
endif;

if( ! function_exists( 'ultimate_mag_get_comment_section' ) ) :
/**
 * Comment template
 * 
 * @since 1.0.1
*/
function ultimate_mag_get_comment_section(){
    // If comments are open or we have at least one comment, load up the comment template.
    if ( comments_open() || get_comments_number() ) :
        comments_template();
    endif;
}
endif;

if( ! function_exists( 'ultimate_mag_content_end' ) ) :
/**
 * Content End
 * 
 * @since 1.0.1
*/
function ultimate_mag_content_end(){

    $ed_featured = get_theme_mod( 'ultimate_mag_ed_featured_section' );
    
    if( !( $ed_featured && is_front_page() && ! is_home() ) ){
        echo '</div></div></div>';// .row /#content /.container
    }
}
endif;

if( ! function_exists( 'ultimate_mag_footer_start' ) ) :
/**
 * Footer Start
 * 
 * @since 1.0.1
*/
function ultimate_mag_footer_start(){
    echo '<footer id="colophon" class="site-footer" role="contentinfo">';

}
endif;


if( ! function_exists( 'ultimate_mag_footer_widgets' ) ) :
/**
 * Footer Widgets
 * 
 * @since 1.0.1 
*/
function ultimate_mag_footer_widgets(){
    if( is_active_sidebar( 'footer-one' ) || is_active_sidebar( 'footer-two' ) || is_active_sidebar( 'footer-three' ) ){?>
        <div class="widget-area">
            <div class="container">
                <div class="row">
                    
                    <?php if( is_active_sidebar( 'footer-one' ) ){ ?>
                    <div class="col-4">
                        <?php dynamic_sidebar( 'footer-one' ); ?>
                    </div>
                    <?php } ?>
                    
                    <?php if( is_active_sidebar( 'footer-two' ) ){ ?>
                    <div class="col-4">
                        <?php dynamic_sidebar( 'footer-two' ); ?>
                    </div>
                    <?php } ?>
                    
                    <?php if( is_active_sidebar( 'footer-three' ) ){ ?>
                    <div class="col-4">
                        <?php dynamic_sidebar( 'footer-three' ); ?>
                    </div>
                    <?php } ?>
                    
                </div><!-- .row -->
            </div><!-- .container -->
        </div><!-- .widget-area -->
<?php } 
}
endif;

if( ! function_exists( 'ultimate_mag_get_footer_copyright' ) ) :
    /**
     * Footer Copyright
     */
    function ultimate_mag_get_footer_copyright(){
        $copyright = get_theme_mod( 'ultimate_mag_footer_copyright' );
        echo '<span class="copyright">';
        if( $copyright ){
            echo wp_kses_post( $copyright );
        }else{
            esc_html_e( 'Copyright &copy; ', 'ultimate-mag' );
            echo date_i18n( esc_html__( 'Y', 'ultimate-mag' ) );
            echo ' <a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a>. ';
        }
        echo '</span>'; 
    }
endif;

if( ! function_exists( 'ultimate_mag_footer_credit' ) ) :
/**
 * Footer Credits 
 */
function ultimate_mag_footer_credit(){
    echo '<div class="footer-b">';
        echo '<div class="container">'; 
            echo '<div class="site-info">';
                ultimate_mag_get_footer_copyright();
                echo '<span class="by">';
                printf( '%s', '<a href="'. esc_url( __( 'https://prosysthemes.com/wordpress-themes/ultimate-mag/', 'ultimate-mag' ) ) .'" target="_blank">'. esc_html__( 'Ultimate Mag', 'ultimate-mag' ) .'</a>' );
                printf( esc_html__( ' By Prosys Theme. Powered by %s', 'ultimate-mag' ), '<a href="'. esc_url( __( 'https://wordpress.org/', 'ultimate-mag' ) ) .'" target="_blank">'. esc_html__( 'WordPress', 'ultimate-mag' ) . '</a>' );
                echo '</span>';
            echo '</div>';
        echo '</div>';
    echo '</div>';
}
endif;

if( ! function_exists( 'ultimate_mag_footer_end' ) ) :
/**
 * Footer End
 * 
 * @since 1.0.1 
*/
function ultimate_mag_footer_end(){
    echo '</footer>'; // #colophon 
}
endif;

if( ! function_exists( 'ultimate_mag_page_end' ) ) :
/**
 * Page End
 * 
 * @since 1.0.1
*/
function ultimate_mag_page_end(){
    ?>
    </div><!-- #page -->
    <?php
}
endif;
