<?php
/**
 * Social Link Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_social_link( $wp_customize ) {

    /** Social Link Settings Settings */
    
    $wp_customize->add_section(
        'ultimate_mag_social_settings',
        array(
            'title' => __( 'Social Link Settings', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );
    
    
    /** Facebook */
    $wp_customize->add_setting(
        'ultimate_mag_facebook',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_facebook',
        array(
            'label' => __( 'Facebook', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );
    
    /** Youtube */
    $wp_customize->add_setting(
        'ultimate_mag_youtube',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_youtube',
        array(
            'label' => __( 'Youtube', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );

    /** Google Plud */
    $wp_customize->add_setting(
        'ultimate_mag_googleplus',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_googleplus',
        array(
            'label' => __( 'Google Plus', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );
    /** Linkedin */
    $wp_customize->add_setting(
        'ultimate_mag_linkedin',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_linkedin',
        array(

            'label' => __( 'Linkedin', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );

    /** Pinterest */
    $wp_customize->add_setting(
        'ultimate_mag_pinterest',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_pinterest',
        array(
            'label' => __( 'Pinterest', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );

    /** Twitter */
    $wp_customize->add_setting(
        'ultimate_mag_twitter',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_twitter',
        array(
            'label' => __( 'Twitter', 'ultimate-mag' ),
            'section' => 'ultimate_mag_social_settings',
            'type' => 'url',
        )
    );
    
    }
add_action( 'customize_register', 'ultimate_mag_customize_register_social_link' );
