<?php

/**
 * Sanitization Functions
 * 
 * @link https://github.com/WPTRT/code-examples/blob/master/customizer/sanitization-callbacks.php 
 */

 function ultimate_mag_sanitize_checkbox( $checked ){
    // Boolean check.
    return ( ( isset( $checked ) && true == $checked ) ? true : false );
 }
  
 function ultimate_mag_sanitize_select( $input, $setting ){
    // Ensure input is a slug.
    $input = sanitize_key( $input );
    
    // Get list of choices from the control associated with the setting.
    $choices = $setting->manager->get_control( $setting->id )->choices;
    
    // If the input is a valid key, return it; otherwise, return the default.
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
 }
 
 function ultimate_mag_sanitize_number_absint( $number, $setting ) {
    // Ensure $number is an absolute integer (whole number, zero or greater).
    $number = absint( $number );
    
    // If the input is an absolute integer, return it; otherwise, return the default
    return ( $number ? $number : $setting->default );
 }

 if( ! function_exists( 'ultimate_mag_get_footer_copyright' ) ) :
    /**
     * Footer Copyright
     */
    function ultimate_mag_get_footer_copyright(){
        $copyright = get_theme_mod( 'footer_copyright' );
        echo '<span class="copyright">';
        if( $copyright ){
            echo wp_kses_post( $copyright );
        }else{
            esc_html_e( 'Copyright &copy; ', 'ultimate-mag' );
            echo date_i18n( esc_html__( 'Y', 'ultimate-mag' ) );
            echo ' <a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( get_bloginfo( 'name' ) ) . '</a>. ';
        }
        echo '</span>'; 
    }
endif;