<?php
/**
 * Home Page Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_home( $wp_customize ) {
    
    global $ultimate_mag_options_pages;
    global $ultimate_mag_options_posts;
    global $ultimate_mag_option_categories;

    /** Home Page Settings */
    $wp_customize->add_panel( 
        'ultimate_mag_home_page_settings',
         array(
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'title' => __( 'Home Page Settings', 'ultimate-mag' ),
            'description' => __( 'Customize Home Page Settings', 'ultimate-mag' ),
        ) 
    );
    
     /** Slider Settings */
    $wp_customize->add_section(
        'ultimate_mag_slider_section_settings',
        array(
            'title'     => __( 'Featured Slider Settings', 'ultimate-mag' ),
            'priority'  => 10,
            'capability' => 'edit_theme_options',
            'panel' => 'ultimate_mag_home_page_settings'
        )
    );
   
    /** Enable/Disable Slider Auto Transition */
    $wp_customize->add_setting(
        'ultimate_mag_slider_auto',
        array(
            'default' => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_auto',
        array(
            'label' => __( 'Enable Slider Auto Transition', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Enable/Disable Slider Loop */
    $wp_customize->add_setting(
        'ultimate_mag_slider_loop',
        array(
            'default' => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_loop',
        array(
            'label' => __( 'Enable Slider Loop', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Enable/Disable Slider Pager */
    $wp_customize->add_setting(
        'ultimate_mag_slider_pager',
        array(
            'default' => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_pager',
        array(
            'label' => __( 'Enable Slider Pager', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Enable/Disable Slider Caption */
    $wp_customize->add_setting(
        'ultimate_mag_slider_caption',
        array(
            'default' => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_caption',
        array(
            'label' => __( 'Enable Slider Caption', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'checkbox',
        )
    );
        
    /** Slider Animation */
    $wp_customize->add_setting(
        'ultimate_mag_slider_animation',
        array(
            'default' => 'slide',
            'sanitize_callback' => 'ultimate_mag_sanitize_select',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_animation',
        array(
            'label' => __( 'Select Slider Animation', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'select',
            'choices' => array(
                'fade' => __( 'Fade', 'ultimate-mag' ),
                'slide' => __( 'Slide', 'ultimate-mag' ),
            )
        )
    );
    
    /** Slider Speed */
    $wp_customize->add_setting(
        'ultimate_mag_slider_speeds',
        array(
            'default' => 400,
            'sanitize_callback' => 'ultimate_mag_sanitize_number_absint',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_speeds',
        array(
            'label' => __( 'Slider Speed', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'text',
        )
    );
    
    /** Slider Pause */
    $wp_customize->add_setting(
        'ultimate_mag_slider_pause',
        array(
            'default' => 6000,
            'sanitize_callback' => 'ultimate_mag_sanitize_number_absint',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_slider_pause',
        array(
            'label' => __( 'Slider Pause', 'ultimate-mag' ),
            'section' => 'ultimate_mag_slider_section_settings',
            'type' => 'text',
        )
    );
    
    for( $i=1; $i<=3; $i++){  
        /** Select Slider Post */
        $wp_customize->add_setting(
            'ultimate_mag_slider_post_'.$i,
            array(
                'default' => '',
                'sanitize_callback' => 'ultimate_mag_sanitize_select',
            )
        );
        
        $wp_customize->add_control(
            'ultimate_mag_slider_post_'.$i,
            array(
                'label' => __( 'Select Post ', 'ultimate-mag' ).$i,
                'section' => 'ultimate_mag_slider_section_settings',
                'type' => 'select',
                'choices' => $ultimate_mag_options_posts,
            )
        );
    }
    
    /** Slider Settings Ends */
    
    /** Featured Section */
    $wp_customize->add_section(
        'ultimate_mag_feature_section_settings',
        array(
            'title' => __( 'Featured Section', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'ultimate_mag_home_page_settings'
        )
    );
    
    /** Enable/Disable Featured Section */
    $wp_customize->add_setting(
        'ultimate_mag_ed_featured_section',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_featured_section',
        array(
            'label' => __( 'Enable Featured Post Section', 'ultimate-mag' ),
            'section' => 'ultimate_mag_feature_section_settings',
            'type' => 'checkbox',
        )
    );

    for( $i=1; $i<=4; $i++){  
    
        /** featured Post */
        $wp_customize->add_setting(
            'ultimate_mag_feature_post_'.$i,
            array(
                'default' => '',
                'sanitize_callback' => 'ultimate_mag_sanitize_select',
            ));
        
        $wp_customize->add_control(
            'ultimate_mag_feature_post_'.$i,
            array(
                'label' => __( 'Select Featured Post ', 'ultimate-mag' ) .$i ,
                'section' => 'ultimate_mag_feature_section_settings',
                'type' => 'select',
                'choices' => $ultimate_mag_options_posts
            ));
    }

    /** Special Section */
    $wp_customize->add_section(
        'ultimate_mag_special_section_settings',
        array(
            'title' => __( 'Special Section', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel' => 'ultimate_mag_home_page_settings'
        )
    );
    
    /** Enable/Disable Special Section */
    $wp_customize->add_setting(
        'ultimate_mag_ed_special_section',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_special_section',
        array(
            'label' => __( 'Enable Special Category Section', 'ultimate-mag' ),
            'section' => 'ultimate_mag_special_section_settings',
            'type' => 'checkbox',
        )
    );


    /** Slider Readmore */
    $wp_customize->add_setting(
        'ultimate_mag_special_title',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_special_title',
        array(
            'label' => __( 'Section Title', 'ultimate-mag' ),
            'section' => 'ultimate_mag_special_section_settings',
            'type' => 'text',
        )
    );
    
    /** Special Post */
    $wp_customize->add_setting(
        'ultimate_mag_special_cat',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_select',
        ));
    
    $wp_customize->add_control(
        'ultimate_mag_special_cat',
        array(
            'label' => __( 'Select Special Category ', 'ultimate-mag' ) .$i ,
            'section' => 'ultimate_mag_special_section_settings',
            'type' => 'select',
            'choices' => ultimate_mag_get_categories(),
    ));

    /** About Section Settings */
    $wp_customize->add_section(
        'ultimate_mag_about_section_settings',
        array(
            'title' => __( 'Homepage Content Section', 'ultimate-mag' ),
            'priority' => 30,
            'capability' => 'edit_theme_options',
            'panel' => 'ultimate_mag_home_page_settings'
        )
    );
    
    /** Enable about Section */   
    $wp_customize->add_setting(
        'ultimate_mag_ed_about_section',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_about_section',
        array(
            'label' => __( 'Enable Homepage Content Section', 'ultimate-mag' ),
            'section' => 'ultimate_mag_about_section_settings',
            'type' => 'checkbox',
        )
    );
    
    /** About Section Ends */
    
}
add_action( 'customize_register', 'ultimate_mag_customize_register_home' );
