<?php
/**
 * Headers Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_header_contact( $wp_customize ) {

    /** Header Settings */
    
    $wp_customize->add_section(
        'ultimate_mag_header_settings',
        array(
            'title' => __( 'Header Settings', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );
    
    /** Enable/Disable Search Form */
    $wp_customize->add_setting(
        'ultimate_mag_ed_search_form',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_search_form',
        array(
            'label' => __( 'Enable Header Search', 'ultimate-mag' ),
            'description' => __( 'Enable Search Icon in header near main navigation.', 'ultimate-mag' ),
            'section' => 'ultimate_mag_header_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Home Text */
    $wp_customize->add_setting(
        'ultimate_mag_phone',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_phone',
        array(
            'label' => __( 'Phone Number', 'ultimate-mag' ),
            'section' => 'ultimate_mag_header_settings',
            'type' => 'text',
        )
    );
    
    /** Header Separator */
    $wp_customize->add_setting(
        'ultimate_mag_email',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_email',
        array(
            'label' => __( 'Email Address', 'ultimate-mag' ),
            'section' => 'ultimate_mag_header_settings',
            'type' => 'text',
        )
    );

    /** Header Settings Ends */
    
    }
add_action( 'customize_register', 'ultimate_mag_customize_register_header_contact' );
