<?php
/**
 * Footer Text Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_footer_text( $wp_customize ) {

    /** Footer Text Settings */
    
    $wp_customize->add_section(
        'ultimate_mag_footer_text_settings',
        array(
            'title' => __( 'Footer Settings', 'ultimate-mag' ),
            'priority' => 90,
            'capability' => 'edit_theme_options',
        )
    );

    /** Home Text */
    $wp_customize->add_setting(
        'ultimate_mag_footer_copyright',
        array(
            'default' => '',
            'sanitize_callback' => 'wp_kses_post',
            'transport'         => 'postMessage'
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_footer_copyright',
        array(
            'label' => __( 'Footer Copyright Text', 'ultimate-mag' ),
            'section' => 'ultimate_mag_footer_text_settings',
            'type' => 'textarea',
        )
    );

    $wp_customize->selective_refresh->add_partial( 'ultimate_mag_footer_copyright', array(
        'selector' => '.site-footer .footer-b span.copyright',
        'render_callback' => 'ultimate_mag_get_footer_copyright',
    ) );
}
add_action( 'customize_register', 'ultimate_mag_customize_register_footer_text' );
