<?php
/**
 * Default Theme Option.
 *
 * @package ultimate_mag
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

 
function ultimate_mag_customize_register_default( $wp_customize ) {

    /* Option list of all categories */
    $ultimate_mag_args = array(
       'type'                     => 'post',
       'orderby'                  => 'name',
       'order'                    => 'ASC',
       'hide_empty'               => 1,
       'hierarchical'             => 1,
       'taxonomy'                 => 'category'
    ); 
    $ultimate_mag_option_categories = array();
    $ultimate_mag_category_lists = get_categories( $ultimate_mag_args );
    $ultimate_mag_option_categories[''] = __( 'Choose Category', 'ultimate-mag' );
    foreach( $ultimate_mag_category_lists as $ultimate_mag_category ){
        $ultimate_mag_option_categories[$ultimate_mag_category->term_id] = $ultimate_mag_category->name;
    }
   

    /** Default Settings */    
    $wp_customize->add_panel( 
        'wp_default_panel',
         array(
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'theme_supports' => '',
            'title' => __( 'Default Settings', 'ultimate-mag' ),
            'description' => __( 'Default section provided by WordPress customizer.', 'ultimate-mag' ),
        ) 
    );
    
    $wp_customize->get_section( 'title_tagline' )->panel     = 'wp_default_panel';
    $wp_customize->get_section( 'colors' )->panel            = 'wp_default_panel';
    $wp_customize->get_section( 'background_image' )->panel  = 'wp_default_panel';
    $wp_customize->get_section( 'static_front_page' )->panel = 'wp_default_panel'; 
    
    $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
    $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_setting( 'background_color' )->transport = 'refresh';
    $wp_customize->get_setting( 'background_image' )->transport = 'refresh';

    }
add_action( 'customize_register', 'ultimate_mag_customize_register_default' );