<?php
/**
 * Ultimate Mag Theme Customizer.
 *
 * @package ultimate_mag
 */

    $ultimate_mag_settings = array( 'info', 'default', 'header', 'breaking-news','catcolor', 'archives', 'advertise', 'social','home', 'breadcrumb', 'footer'  );

    /* Option list of all post */	
    $ultimate_mag_options_posts = array();
    $ultimate_mag_options_posts_obj = get_posts('posts_per_page=-1');
    $ultimate_mag_options_posts[''] = __( 'Choose Post', 'ultimate-mag' );
    foreach ( $ultimate_mag_options_posts_obj as $ultimate_mag_posts ) {
    	$ultimate_mag_options_posts[$ultimate_mag_posts->ID] = $ultimate_mag_posts->post_title;
    }
    
 	/* Option list of all page */   
    $ultimate_mag_options_pages = array();
    $ultimate_mag_options_pages_obj = get_pages('posts_per_page=-1');
    $ultimate_mag_options_pages[''] = __( 'Choose Page', 'ultimate-mag' );
    foreach ( $ultimate_mag_options_pages_obj as $ultimate_mag_pages ) {
        $ultimate_mag_options_pages[$ultimate_mag_pages->ID] = $ultimate_mag_pages->post_title;
    }

    /* Option list of all categories */
    $ultimate_mag_args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'order'                    => 'ASC',
	   'hide_empty'               => 1,
	   'hierarchical'             => 1,
	   'taxonomy'                 => 'category'
    ); 
    $ultimate_mag_option_categories = array();
    $ultimate_mag_category_lists = get_categories( $ultimate_mag_args );
    $ultimate_mag_option_categories[''] = __( 'Choose Category', 'ultimate-mag' );
    foreach( $ultimate_mag_category_lists as $ultimate_mag_category ){
        $ultimate_mag_option_categories[$ultimate_mag_category->term_id] = $ultimate_mag_category->name;
    }

	foreach( $ultimate_mag_settings as $setting ){
		require get_template_directory() . '/inc/customizer/' . $setting . '.php';
	}

/**
 * Sanitization Functions
*/
require get_template_directory() . '/inc/customizer/sanitization-functions.php';

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ultimate_mag_customize_preview_js() {
    wp_enqueue_script( 'ultimate_mag_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'ultimate_mag_customize_preview_js' );
