<?php
/**
 * Custom Options
 *
 * @package Ultimate_Mag
 */
 
function ultimate_mag_customize_register_catcolor( $wp_customize ) {
    
    /** Category Color Settings */
    $wp_customize->add_section(
        'ultimate_mag_cat_color_settings',
        array(
            'title'       => __( 'Category Color Settings', 'ultimate-mag' ),
            'description' => __( 'Choose color for specific category.', 'ultimate-mag' ),
            'priority'    => 50,
            'capability'  => 'edit_theme_options',
        )
    );
    
    $args = array(
	   'type'                     => 'post',
	   'orderby'                  => 'name',
	   'hide_empty'               => 0,
	   'taxonomy'                 => 'category'
    ); 
    
    $category_lists = get_categories( $args );
    
    foreach( $category_lists as $category ){
        
        $wp_customize->add_setting( 'ultimate_mag_category_color_' . $category->term_id, 
            array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_hex_color'
            )
        );

        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'ultimate_mag_category_color_' . $category->term_id, 
            array(
                'label'    => $category->name,
                'section'  => 'ultimate_mag_cat_color_settings',
                'settings' => 'ultimate_mag_category_color_' . $category->term_id,
            )
        ));
    }
    
}
add_action( 'customize_register', 'ultimate_mag_customize_register_catcolor' );