<?php
/**
 * Headers Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_breaking_news_contact( $wp_customize ) {

    /** Breaking News Settings */
    
    $wp_customize->add_section(
        'ultimate_mag_breaking_news_settings',
        array(
            'title' => __( 'Breaking News Settings', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'description' => __( 'Select category to enable Breaking News section.', 'ultimate-mag')
        )
    );
    
    /** Header Separator */
    $wp_customize->add_setting(
        'ultimate_mag_breaking_news_label',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_breaking_news_label',
        array(
            'label' => __( 'Breaking News label', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breaking_news_settings',
            'type' => 'text',
        )
    );

    /** Header Separator */
    $wp_customize->add_setting(
        'ultimate_mag_breaking_news_cat',
        array(
            'default' => '',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_breaking_news_cat',
        array(
            'label' => __( 'News Category', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breaking_news_settings',
            'type' => 'select',
            'choices' => ultimate_mag_get_categories(),
        )
    );
    
    }
add_action( 'customize_register', 'ultimate_mag_customize_register_breaking_news_contact' );
