<?php
/**
 * Breadcrumbs Options
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_breadcrumbs( $wp_customize ) {

    /** BreadCrumb Settings */
    
    $wp_customize->add_section(
        'ultimate_mag_breadcrumb_settings',
        array(
            'title' => __( 'Breadcrumb Settings', 'ultimate-mag' ),
            'priority' => 50,
            'capability' => 'edit_theme_options',
        )
    );
    
    /** Enable/Disable BreadCrumb */
    $wp_customize->add_setting(
        'ultimate_mag_ed_breadcrumb',
        array(
            'default' => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_breadcrumb',
        array(
            'label' => __( 'Enable Breadcrumb', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breadcrumb_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Show/Hide Current */
    $wp_customize->add_setting(
        'ultimate_mag_ed_current',
        array(
            'default' => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_current',
        array(
            'label' => __( 'Show current', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breadcrumb_settings',
            'type' => 'checkbox',
        )
    );
    
    /** Home Text */
    $wp_customize->add_setting(
        'ultimate_mag_breadcrumb_home_text',
        array(
            'default' => __( 'Home', 'ultimate-mag' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_breadcrumb_home_text',
        array(
            'label' => __( 'Breadcrumb Home Text', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breadcrumb_settings',
            'type' => 'text',
        )
    );
    
    /** Breadcrumb Separator */
    $wp_customize->add_setting(
        'ultimate_mag_breadcrumb_separator',
        array(
            'default' => __( '>', 'ultimate-mag' ),
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_breadcrumb_separator',
        array(
            'label' => __( 'Breadcrumb Separator', 'ultimate-mag' ),
            'section' => 'ultimate_mag_breadcrumb_settings',
            'type' => 'text',
        )
    );
    /** BreadCrumb Settings Ends */
    
    }
add_action( 'customize_register', 'ultimate_mag_customize_register_breadcrumbs' );
