<?php
/**
 * Custom Options
 *
 * @package Ultimate_Mag
 */
 
function ultimate_mag_customize_register_archives( $wp_customize ) {
    
    /** Category Color Settings */
    $wp_customize->add_section(
        'ultimate_mag_archives_settings',
        array(
            'title'       => __( 'Archives Pages Settings', 'ultimate-mag' ),
            'description' => __( 'Choose color for specific category.', 'ultimate-mag' ),
            'priority'    => 50,
            'capability'  => 'edit_theme_options',
        )
    );

    /* Archives Layout */
    $wp_customize->add_setting(
        'ultimate_mag_archives_layout',
        array(
            'default' => 'horizontal',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_archives_layout',
        array(
            'label' => __( 'Archives page layout', 'ultimate-mag' ),
            'section' => 'ultimate_mag_archives_settings',
            'type' => 'select',
            'choices' => array(
                'horizontal' => __( 'Large Image + Content', 'ultimate-mag'),
                'vertical' => __( 'Left Side Image + Content', 'ultimate-mag'),
            ),
        )
    );
    

    
}
add_action( 'customize_register', 'ultimate_mag_customize_register_archives' );