<?php
/**
 * Advertisement
 *
 * @package ultimate_mag
 */
 
function ultimate_mag_customize_register_advertise( $wp_customize ) {

    /** Advertisement Settings */
    $wp_customize->add_section(
        'ultimate_mag_ad_settings',
        array(
            'title' => __( 'Header Advertisement Settings', 'ultimate-mag' ),
            'description' => __( 'Header AD Settings', 'ultimate-mag' ),
            'priority' => 20,
            'capability' => 'edit_theme_options',
        )
    );
    
    /** Enable/Disable Header AD */
    $wp_customize->add_setting(
        'ultimate_mag_ed_header_ad',
        array(
            'default'           => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_ed_header_ad',
        array(
            'label'   => __( 'Enable Header Advertisement', 'ultimate-mag' ),
            'section' => 'ultimate_mag_ad_settings',
            'type'    => 'checkbox',
        )
    );
    
    /** Open Link in Different Tab */
    $wp_customize->add_setting(
        'ultimate_mag_open_link_diff_tab',
        array(
            'default'           => '1',
            'sanitize_callback' => 'ultimate_mag_sanitize_checkbox',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_open_link_diff_tab',
        array(
            'label'   => __( 'Open Link in Different Tab', 'ultimate-mag' ),
            'section' => 'ultimate_mag_ad_settings',
            'type'    => 'checkbox',
        )
    );
    
    /** Header Advertisement */
    $wp_customize->add_setting(
        'ultimate_mag_header_ad',
        array(
            'default'           => '',
            'sanitize_callback' => 'ultimate_mag_sanitize_number_absint',
        )
    );
    
    $wp_customize->add_control(
       new WP_Customize_Cropped_Image_Control(
           $wp_customize,
           'ultimate_mag_header_ad',
           array(
               'label'   => __( 'Upload Header Advertisement', 'ultimate-mag' ),
               'section' => 'ultimate_mag_ad_settings',
               'width'   => 670,
               'height'  => 90,
           )
       )
    );
    
    /** Header AD Link */
    $wp_customize->add_setting(
        'ultimate_mag_header_ad_link',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    
    $wp_customize->add_control(
        'ultimate_mag_header_ad_link',
        array(
            'label' => __( 'Header AD Link', 'ultimate-mag' ),
            'section' => 'ultimate_mag_ad_settings',
            'type' => 'url',
        )
    );

}
add_action( 'customize_register', 'ultimate_mag_customize_register_advertise' );
