<?php
/**
 * Ultimate Mag functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ultimate_mag
 */

if ( ! function_exists( 'ultimate_mag_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ultimate_mag_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Ultimate Mag, use a find and replace
		 * to change 'ultimate-mag' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'ultimate-mag', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary', 'ultimate-mag' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'ultimate_mag_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Custom Image Size
	    add_image_size( 'ultimate-mag-slider', 750, 461, true );
	    add_image_size( 'ultimate-mag-four-col', 480, 360, true );
	    add_image_size( 'ultimate-mag-six-col', 600, 300, true );
	    add_image_size( 'ultimate-mag-with-sidebar', 833, 474, true );
	    add_image_size( 'ultimate-mag-without-sidebar', 1140, 474, true );

	    add_image_size( 'ultimate-mag-recent-post', 78, 78, true );
	    add_image_size( 'ultimate-mag-three-col', 360 , 240, true );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'header-text' => array( 'site-title', 'site-description' ),
		) );
	}
endif;
add_action( 'after_setup_theme', 'ultimate_mag_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ultimate_mag_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'ultimate_mag_content_width', 750 );
}
add_action( 'after_setup_theme', 'ultimate_mag_content_width', 0 );

/**
* Adjust content_width value according to template.
*
* @return void
*/
function ultimate_mag_template_redirect_content_width() {
	// Full Width in the absence of sidebar.
	if( is_page() ){
	   $sidebar_layout = ultimate_mag_sidebar_layout();
       if( ( $sidebar_layout == 'no-sidebar' ) || ! ( is_active_sidebar( 'right-sidebar' ) ) ) $GLOBALS['content_width'] = 1140;
        
	}elseif ( ! ( is_active_sidebar( 'right-sidebar' ) ) ) {
		$GLOBALS['content_width'] = 1170;
	}
}

/**
 * Enqueue scripts and styles.
 */
function ultimate_mag_scripts() {
	$ultimate_mag_query_args = array(
		'family' => 'Oxygen:400,700|Lato:400,700,400italic',
		);

	wp_enqueue_style( 'ultimate-mag-google-fonts', add_query_arg( $ultimate_mag_query_args, "//fonts.googleapis.com/css" ) );

    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/all.css' );
    wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/css/owl.carousel.css' );
    wp_enqueue_style( 'owl-theme-default', get_template_directory_uri() . '/css/owl.theme.default.css' );
    wp_enqueue_style( 'jquery-ticker', get_template_directory_uri() . '/css/ticker-style.css' );

    wp_enqueue_style( 'slicknav', get_template_directory_uri() . '/css/slicknav.min.css' );
    wp_enqueue_style( 'ultimate-mag-style', get_stylesheet_uri(), ULTIMATE_MAG_THEME_VERSION  );   
    

    wp_enqueue_script( 'jquery-slicknav', get_template_directory_uri() . '/js/jquery.slicknav.js', array('jquery'), '2.2.1', true );
    wp_enqueue_script( 'jquery-matchHeight', get_template_directory_uri() . '/js/jquery.matchHeight.js', array('jquery'), ULTIMATE_MAG_THEME_VERSION, true );
    wp_enqueue_script( 'jquery-ticker', get_template_directory_uri() . '/js/jquery.ticker.js' , array('jquery'), 'ULTIMATE_MAG_THEME_VERSION', true );
	wp_enqueue_script( 'jquery-owl-carousel', get_template_directory_uri() . '/js/jquery.owl.carousel.js', array('jquery'), '2.2.1', true );
	wp_enqueue_script( 'ultimate-mag-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), ULTIMATE_MAG_THEME_VERSION, true );
	wp_enqueue_script( 'ultimate-mag-navigation', get_template_directory_uri() . '/js/navigation.js', array(), ULTIMATE_MAG_THEME_VERSION, true );
    wp_register_script( 'ultimate-mag-custom', get_template_directory_uri() . '/js/custom.js', array('jquery'), ULTIMATE_MAG_THEME_VERSION , true );
    
    $slider_auto      = get_theme_mod( 'ultimate_mag_slider_auto', '1' );
    $slider_loop      = get_theme_mod( 'ultimate_mag_slider_loop', '1' );
    $slider_pager     = get_theme_mod( 'ultimate_mag_slider_pager', '1' );    
    $slider_animation = get_theme_mod( 'ultimate_mag_slider_animation', 'slide' );
    $slider_speed     = get_theme_mod( 'ultimate_mag_slider_speeds', 400 );
    $slider_pause     = get_theme_mod( 'ultimate_mag_slider_pause', 6000 );
    
    $array = array(
    	'hsearch' 	=> get_theme_mod( 'ultimate_mag_ed_search_form'),
        'auto'      => esc_attr( $slider_auto ),
        'loop'      => esc_attr( $slider_loop ),
        'pager'     => esc_attr( $slider_pager ),
        'animation' => esc_attr( $slider_animation ),
        'speed'     => absint( $slider_speed ),
        'pause'     => absint( $slider_pause ),
    );
    
    wp_localize_script( 'ultimate-mag-custom', 'ultimate_mag_data', $array );
    wp_enqueue_script( 'ultimate-mag-custom' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ultimate_mag_scripts' );

if ( is_admin() ) : // Load only if we are viewing an admin page

function ultimate_mag_admin_scripts() {
	
	wp_enqueue_style( 'ultimate-mag-admin-style',get_template_directory_uri().'/inc/css/admin.css', ULTIMATE_MAG_THEME_VERSION, 'screen' );
    
}

add_action( 'admin_enqueue_scripts', 'ultimate_mag_admin_scripts' );

endif;

if( ! function_exists( 'ultimate_mag_customizer_js' ) ) :
/** 
 * Registering and enqueuing scripts/stylesheets for Customizer controls.
 */ 
function ultimate_mag_customizer_js() {
    wp_enqueue_script( 'ultimate-mag-customizer-js', get_template_directory_uri() . '/inc/js/admin.js', array('jquery'), ULTIMATE_MAG_THEME_VERSION , true  );
}
endif;
add_action( 'customize_controls_enqueue_scripts', 'ultimate_mag_customizer_js' );


/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function ultimate_mag_body_classes( $classes ) {
	global $post;
    $ed_slider = get_theme_mod( 'ultimate_mag_ed_featured_section','1' );
	$archives_layout = get_theme_mod( 'ultimate_mag_archives_layout', 'horizontal'); 

	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if( $ed_slider && is_front_page() && !is_home() ) {
        $classes[] = 'has-slider';
    }

	// Adds a class of custom-background-image to sites with a custom background image.
	if ( get_background_image() ) {
	$classes[] = 'custom-background-image';
	}

	// Adds a class of custom-background-color to sites with a custom background color.
	if ( get_background_color() != 'ffffff' ) {
	$classes[] = 'custom-background-color';
	}

	if(is_page()){
	$ultimate_mag_post_class = ultimate_mag_sidebar_layout(); 
	if( $ultimate_mag_post_class == 'no-sidebar' )
	$classes[] = 'full-width';
	}

	if(is_archive() || is_home()){
		if( $archives_layout  == 'vertical'){
		$classes[] = 'blog-layout-vertical';
		} else {
			$classes[] = 'blog-layout-horizontal';
		}
	}

	if( !( is_active_sidebar( 'right-sidebar' )) || is_404() ) {
	  $classes[] = 'full-width'; 
	}

	return $classes;
}
add_filter( 'body_class', 'ultimate_mag_body_classes' );

/** 
 * Hook to move comment text field to the bottom in WP 4.4 
 *
 * @link http://www.wpbeginner.com/wp-tutorials/how-to-move-comment-text-field-to-bottom-in-wordpress-4-4/  
 */
function ultimate_mag_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}


/* Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function ultimate_mag_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'ultimate_mag_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'ultimate_mag_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so ultimate_mag_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so ultimate_mag_categorized_blog should return false.
		return false;
	}
}


/**
 * Flush out the transients used in ultimate_mag_categorized_blog.
 */
function ultimate_mag_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'ultimate_mag_categories' );
}


if ( ! function_exists( 'ultimate_mag_excerpt_more' )  ) :
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... * 
 */
function ultimate_mag_excerpt_more( $more ) {
	if ( ! is_admin() ){
		return ' &hellip; ';
	}else{
		return $more;
	}

}
endif;
add_filter( 'excerpt_more', 'ultimate_mag_excerpt_more' );

if ( ! function_exists( 'ultimate_mag_excerpt_length' ) ) :
/**
 * Changes the default 55 character in excerpt 
*/
function ultimate_mag_excerpt_length( $length ) {
	if ( ! is_admin() ){
    	return 20;
	}else{
		return $length;
	}
}
endif;
add_filter( 'excerpt_length', 'ultimate_mag_excerpt_length', 999 );
