<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package ultimate_mag
 * @since 1.0.0
 * @version 1.0.0
 */

$featured_enable     = get_theme_mod( 'ultimate_mag_ed_featured_section' );
$about_enable      = get_theme_mod( 'ultimate_mag_ed_about_section');

get_header(); 
           
    if ( 'posts' == get_option( 'show_on_front' ) ) {
        include( get_home_template() );
    }elseif( $featured_enable || $about_enable ){ 
        /**
         * Home Page Contents
         * 
         * @hooked ultimate_mag_featured
         * @hooked ultimate_mag_special 
         */
        do_action( 'ultimate_mag_home_page_featured' );
        ?>
        <div id="content" class="site-content">
            <div class="container">
                <div class="row">
                <?php
                    /**
                     * Home Page Contents
                     * 
                     * @hooked ultimate_mag_about     - 30
                    */
                    do_action( 'ultimate_mag_home_page' );
                ?>
            </div>
        </div>
    </div>
   
    <?php        
    }else {
        include( get_page_template() );
    }
get_footer();