<?php
/**
 * Sets up single pages
 * @package tweaker5
 */
?>

<?php get_header(); ?>
    
	<?php if(is_active_sidebar( 'single-sidebar' )): ?>
        <section class="col grid-8 site-content">
    <?php else: ?>
        <section class="col grid-12 site-content">
    <?php endif; ?>

    <?php while ( have_posts() ) : the_post(); ?>

        <?php get_template_part( 'content', 'single' ); ?>

        <?php tweaker5_post_nav(); ?>
        
        <?php $tweaker5_author = get_the_author_meta('description'); ?>
        <?php if ( $tweaker5_author ): ?>
            <div class="row section info-boxes">
            
                <div class="col grid-6 info">
                    <h3>Meta Data</h3>
                    <p>Title: <?php the_title(); ?><br />Date Posted: <?php the_date(); ?><br />Posted By: <?php the_author_posts_link(); ?><br />Category: <?php echo get_the_category_list(', '); ?><br /><?php the_tags(); ?><br /><?php edit_post_link('Edit'); ?></p>
                </div><?php // close .info ?>
    
                <div class="col grid-6 bio">
                    <h3><?php the_author_meta('first_name'); ?> <?php the_author_meta('last_name'); ?></h3>
                    <span class="alignright"><?php echo get_avatar( get_the_author_meta('email') , 50 ); ?></span>
                    <p><?php the_author_meta('description'); ?></p>
                    <p>Website: <a class="external" href="<?php the_author_meta('user_url');?>"><?php the_author_meta('user_url');?></a></p>
                </div><?php // close .bio ?>

            </div><?php // close .info-boxes ?>
            
        <?php else: ?>
            
            <div class="row section info-boxes">
            
                <div class="col grid-12 info">
                    <h3>Meta Data</h3>
                    <p>Title: <?php the_title(); ?><br />Date Posted: <?php the_date(); ?><br />Posted By: <?php the_author_posts_link(); ?><br />Category: <?php echo get_the_category_list(', '); ?><br /><?php the_tags(); ?><br /><?php edit_post_link('Edit'); ?></p>
                </div><?php // close .info ?>

            </div><?php // close .info-boxes ?>
            
        <?php endif; ?>
        
        <?php
            // If comments are open or we have at least one comment, load up the comment template
            if ( comments_open() || '0' != get_comments_number() ) :
                comments_template('', true);
            endif;
        ?>
        
    <?php endwhile; // end of the loop. ?>

    </section><?php // close .site-content ?>

    <?php if(is_active_sidebar( 'single-sidebar' )): ?>
        <?php get_sidebar('single'); ?>
    <?php endif; ?>
        
<?php get_footer(); ?>