<?php
/**
 * Sets up the search pages
 * @package tweaker5
 */
?>

<?php get_header(); ?>

	<div class="row section">
        
		<?php if(is_active_sidebar( 'blog-sidebar' )): ?>
            <section class="col grid-8 site-content">
        <?php else: ?>
            <section class="col grid-12 site-content">
        <?php endif; ?>

		<?php if ( have_posts() ) : ?>

			<header class="content-header">
				<h1><?php printf( __( 'Search Results for: %s', 'tweaker5' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
			</header><!-- .page-header -->

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<?php if (tweaker5_show_posts_nav()) : ?>
                    <div class="paginate">
                        <?php tweaker5_paginate(); ?>
                    </div><?php // close .paginate ?>
                <?php endif; ?>
                <!-- replace the entire if statement above with '< ?php tweaker5_paging_nav(); ? >' 
                should you prefer the old style navigation. Please remove the spaces from the 
                opening and closing brackets. -->

		<?php else : ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                <div class="content-header">
                	<h1><?php printf( __( 'Search Results for: %s', 'tweaker5' ), '<span>' . get_search_query() . '</span>' ); ?></h1>
                </div>
                
                <p><?php _e( 'You have searched for something that could not be found. The following might be of assistance in finding whatever you are looking for:', 'tweaker5' ); ?></p>
            	
            </article><?php // close #post ?>
            
            <div class="row section">
                
                <div class="col grid-6 sidebar-widget">
                    <h3 class="sidebar-widget-title">Search</h3>
                    <?php get_search_form(); ?>
                </div>
                
                <div class="col grid-6">
                <?php the_widget('WP_Widget_Recent_Posts', array('number' => 5), array('before_widget' => '<div class="sidebar-widget">','after_widget' => '</div>','before_title' => '<h3 class="sidebar-widget-title">', 'after_title' => '</h3>')); ?>
                </div>
            
            </div>

		<?php endif; ?>

	</section>

		<?php if(is_active_sidebar( 'blog-sidebar' )): ?>
            <?php get_sidebar(); ?>
        <?php endif; ?>
        
    </div><?php // close .row ?>

<?php get_footer(); ?>