<?php
/**
 * tweaker5 Theme Customizer
 *
 * @package tweaker5
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function tweaker5_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	// Add Tweaker5 Navigation Section
	$wp_customize->add_section( 'tweaker5_navigation_section' , array(
    'title' => __( 'Tweaker5 Navigation Options', 'tweaker5' ),
    'priority' => 201,
    'description' => __( 'The menu settings required by the theme for the top and primary menus. These menus need to be setup in the back-end before these settings can take effect.', 'tweaker5' ),
	) );
	// Add Tweaker5 Copyright Section
	$wp_customize->add_section( 'tweaker5_copyright_section' , array(
    'title' => __( 'Tweaker5 Copyright Options', 'tweaker5' ),
    'priority' => 202,
    'description' => __( 'The copyright info in the footer is shown as <strong>Copyright &copy; [start date] - [current year] [copyright owner]</strong>. You can change the start date and copyright owner here.', 'tweaker5' ),
	) );
	//Add Tweaker5 Navigation Settings
	$wp_customize->add_setting( 'tweaker5_top_menu_setting', array( 
	'default' => 'standard',
	'sanitize_callback' => 'tweaker5_sanitize_top_menu', 
	));
	$wp_customize->add_setting( 'tweaker5_primary_menu_setting', array( 
	'default' => 'drop',
	'sanitize_callback' => 'tweaker5_sanitize_primary_menu', 
	));
	//Add Tweaker5 Copyright Settings
	$wp_customize->add_setting( 'tweaker5_first_date_setting', array( 
	'default' => '',
	'sanitize_callback' => 'tweaker5_sanitize_text', 
	));
	$wp_customize->add_setting( 'tweaker5_copyright_owner_setting', array( 
	'default' => '',
	'sanitize_callback' => 'tweaker5_sanitize_text', 
	));
	// Add Navigation Controls
	// Add Top Menu Control
	$wp_customize->add_control( 'tweaker5_top_menu', array(
    'label'      => __( 'Top Menu', 'tweaker5' ),
    'section'    => 'tweaker5_navigation_section',
    'settings'   => 'tweaker5_top_menu_setting',
    'type'       => 'select',
    'choices'    => array(
        'standard' => 'Standard Menu',
        'social' => 'Social Nav',
        ),
	) );
	// Add Primary Menu Control
	$wp_customize->add_control( 'tweaker5_primary_menu', array(
    'label'      => __( 'Primary Menu', 'tweaker5' ),
    'section'    => 'tweaker5_navigation_section',
    'settings'   => 'tweaker5_primary_menu_setting',
    'type'       => 'select',
    'choices'    => array(
        'drop' => 'Drop Down Menu',
        'flat' => 'Flat Menu',
        ),
	) );
	// Add Copyright Controls
	// Add First Date Control
	$wp_customize->add_control( 'tweaker5_first_date', array(
    'label'      => __( 'First Date', 'tweaker5' ),
    'section'    => 'tweaker5_copyright_section',
    'settings'   => 'tweaker5_first_date_setting',
    'type'       => 'text',
	) );
	// Add Copyright Owner Control
	$wp_customize->add_control( 'tweaker5_copyright_owner', array(
    'label'      => __( 'Copyright Owner', 'tweaker5' ),
    'section'    => 'tweaker5_copyright_section',
    'settings'   => 'tweaker5_copyright_owner_setting',
    'type'       => 'text',
	) );
}
add_action( 'customize_register', 'tweaker5_customize_register' );
// Sanitize input
function tweaker5_sanitize_text( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}
function tweaker5_sanitize_radio( $input ) {
    $valid = array(
        'yes' => 'Yes',
        'no' => 'No',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
function tweaker5_sanitize_select( $input ) {
    $valid = array(
        '0' => 'None',
        '1' => 'One',
		'2' => 'Two',
		'3' => 'Three',
		'4' => 'Four',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
function tweaker5_sanitize_top_menu( $input ) {
    $valid = array(
        'standard' => 'Standard Menu',
        'social' => 'Social Nav',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
function tweaker5_sanitize_primary_menu( $input ) {
    $valid = array(
        'drop' => 'Drop Down Menu',
        'flat' => 'Flat Menu',
    );
 
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
function tweaker5_sanitize_url( $input ) {
    return esc_url( $input );
}
/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function tweaker5_customize_preview_js() {
	wp_enqueue_script( 'tweaker5_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'tweaker5_customize_preview_js' );