<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head lang="en">
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php wp_title('|', true, 'right'); ?></title>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<meta name="description" content="<?php bloginfo('description'); ?>">
<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="page" class="hfeed site site-wrapper">
	
    <?php // The skip to content link ?>
    <a class="screen-reader-text skip-link" href="#content"><?php _e( 'Skip to content', 'tweaker5' ); ?></a>

	<?php // The top menu ?>
    <nav class="row-no-margin section">
        
        <div class="top-menu">
        	<?php $tweaker5_top_menu = wp_kses_post( get_theme_mod( 'tweaker5_top_menu_setting' ) ); ?>
			<?php if($tweaker5_top_menu == 'social' ) : ?>
				<?php wp_nav_menu( array( 'theme_location' => 'social', 'depth' => '-1', 'fallback_cb' => '', 'link_before' => '<span class="screen-reader-text">', 'link_after' => '</span>' ) ); ?>
        	<?php elseif ($tweaker5_top_menu == 'standard' ) : ?>
				<?php wp_nav_menu( array( 'theme_location' => 'top', 'depth' => '-1', 'fallback_cb' => '' ) ); ?>
        	<?php endif; ?>
        </div><?php // close .top-menu ?>
        
	</nav><?php // close .row ?>
    
    
	<header class="main-header">
    
		<?php // The Custom Header
        // The site title and description does not appear directly over the custom image. 
        // The reason for this is that I wanted the header image to resize with the screen resolution.
        // Only the actual stuff selected on the Custom Header page will be shown:
        // The image and text, image only, text only or nothing at all. ?>
        <?php if ( get_header_image() ) : ?>
            <?php if (display_header_text()): ?>
                <div class="row-no-margin section">
            <?php else: ?>
                <div class="row section">
             <?php endif; ?>
                <div id="site-header">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                        <img src="<?php header_image(); ?>" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="">
                    </a>
                </div><?php // close .site-header ?>
            </div><?php // close .row ?>
        <?php endif; ?>
        
        <?php if (display_header_text()): ?>
        <div id="masthead" class="row section site-header" role="banner">
            <div class="col grid-12 header-main">
                <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
            </div>
        </div><?php // close #masthead ?>
        <?php endif; ?>
    
    </header>
	
    <?php // The Primary Menu ?>
    <nav class="row section">
    
        <nav id="site-navigation" class="col grid-12 main-navigation" role="navigation">
            <h1 class="menu-toggle"><?php _e( 'Menu', 'tweaker5' ); ?></h1>
			<?php $tweaker5_primary_menu = wp_kses_post( get_theme_mod( 'tweaker5_primary_menu_setting' ) ); ?>
			<?php if($tweaker5_primary_menu == 'drop' ) : ?>
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'depth' => '3' ) ); ?>
            <?php else: ?>
				<?php wp_nav_menu( array( 'theme_location' => 'primary', 'depth' => '-1' ) ); ?>
            <?php endif; ?>
        </nav><?php // close .main-navigation ?>
    
    </nav><?php // close .row ?>
	
    <?php // The main division holding both the content and sidebar on all pages ?>	
    <section id="content" class="row-no-margin section site-main"><?php // closed in footer.php ?>